/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws.cli;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.coderazzi.openapi4aws.Configuration;
import net.coderazzi.openapi4aws.O4A_Exception;

class AuthorizerParameter
implements Configuration.Authorizer {
    private static final Map<Object, Object> AUTHORIZER_FLOWS = Collections.emptyMap();
    private static final String AUTHORIZATION_TYPE = "oauth2";
    private static final String AUTHORIZER_TYPE = "jwt";
    private final AuthorizerParameter defaultAuthorizer;
    private final Map<Object, Object> flows = AUTHORIZER_FLOWS;
    private String identitySource;
    private String issuer;
    private List<String> audiences;
    private String authorizationType;
    private String type;

    public AuthorizerParameter(AuthorizerParameter defaultAuthorizer) {
        this.defaultAuthorizer = defaultAuthorizer;
    }

    @Override
    public String getIdentitySource() {
        return this.identitySource == null && this.defaultAuthorizer != null ? this.defaultAuthorizer.getIdentitySource() : this.identitySource;
    }

    public void setIdentitySource(String identitySource) {
        this.identitySource = identitySource;
    }

    @Override
    public String getIssuer() {
        return this.issuer == null && this.defaultAuthorizer != null ? this.defaultAuthorizer.getIssuer() : this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Override
    public List<String> getAudience() {
        return this.audiences == null && this.defaultAuthorizer != null ? this.defaultAuthorizer.getAudience() : this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    @Override
    public Map<Object, Object> getFlows() {
        return this.flows;
    }

    @Override
    public String getAuthorizationType() {
        return AUTHORIZATION_TYPE;
    }

    public void setAuthorizationType(String authorizationType) {
        if (AUTHORIZATION_TYPE.equals(authorizationType)) {
            throw new O4A_Exception(authorizationType + " : not a valid authorization type");
        }
        this.authorizationType = authorizationType;
    }

    @Override
    public String getType() {
        return AUTHORIZER_TYPE;
    }

    public void setType(String authorizerType) {
        if (AUTHORIZER_TYPE.equals(this.authorizationType)) {
            throw new O4A_Exception(this.authorizationType + " : not a valid authorizer type");
        }
        this.type = authorizerType;
    }
}

