/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.coderazzi.openapi4aws.Configuration;
import net.coderazzi.openapi4aws.O4A_Exception;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Openapi4AWS {
    public static final String DEFAULT_INTEGRATION_TYPE = "http_proxy";
    public static final String DEFAULT_INTEGRATION_CONNECTION_TYPE = "INTERNET";
    private static final String PATHS = "paths";
    private static final String DEFAULT_INTEGRATION_PAYLOAD_FORMAT_VERSION = "1.0";
    private final Configuration configuration;

    public Openapi4AWS(Configuration handler) {
        this.configuration = handler;
    }

    public void handle(Collection<Path> paths, Path outputFolder) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        for (Path path : paths) {
            Map specification;
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                specification = (Map)yaml.load(is);
            }
            catch (IOException ioex) {
                throw new O4A_Exception("IOError reading file '" + path + "' : " + ioex);
            }
            catch (ClassCastException cex) {
                specification = null;
            }
            if (specification == null) {
                throw new O4A_Exception(path + ": invalid openapi content");
            }
            try {
                this.augment(specification);
            }
            catch (O4A_Exception ex) {
                throw new O4A_Exception(path + ex.getMessage());
            }
            Path outputPath = outputFolder == null ? path : outputFolder.resolve(path.getFileName());
            try {
                OutputStream os = Files.newOutputStream(outputPath, new OpenOption[0]);
                try {
                    yaml.dump((Object)specification, (Writer)new OutputStreamWriter(os));
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            catch (IOException ioex) {
                throw new O4A_Exception("IOError writing file '" + path + "' : " + ioex);
            }
        }
    }

    private void augment(Map<String, Object> specification) {
        Map<String, Configuration.Authorizer> authorizers = this.configuration.getAuthorizers();
        if (authorizers != null && !authorizers.isEmpty()) {
            Map<String, Object> securitySchemas = this.getMap(this.getMap(specification, "components"), "securitySchemes");
            authorizers.forEach((name, authorizer) -> securitySchemas.put((String)name, this.createSecuritySchema((Configuration.Authorizer)authorizer)));
        }
        this.getMap(specification, PATHS).forEach((path, pathSpec) -> {
            String location = "paths:" + path;
            this.castToMap(pathSpec, location).forEach((method, v) -> {
                String subLocation = location + ":" + method;
                Map<String, Object> methodSpec = this.castToMap(v, subLocation);
                List<String> tags = this.castToList(methodSpec.get("tags"), subLocation);
                Configuration.Integration spec = this.configuration.getIntegration((String)path, tags);
                if (spec != null) {
                    LinkedHashMap<String, String> integration = new LinkedHashMap<String, String>();
                    integration.put("payloadFormatVersion", DEFAULT_INTEGRATION_PAYLOAD_FORMAT_VERSION);
                    integration.put("type", DEFAULT_INTEGRATION_TYPE);
                    integration.put("connectionType", DEFAULT_INTEGRATION_CONNECTION_TYPE);
                    integration.put("httpMethod", method.toUpperCase(Locale.ROOT));
                    integration.put("uri", spec.getUri((String)path));
                    methodSpec.put("x-amazon-apigateway-integration", integration);
                    String authorizerName = spec.getAuthorizer();
                    if (authorizerName != null) {
                        LinkedHashMap<String, ArrayList<String>> scopes = new LinkedHashMap<String, ArrayList<String>>();
                        scopes.put(authorizerName, new ArrayList<String>(spec.getScopes()));
                        ArrayList<LinkedHashMap<String, ArrayList<String>>> securityScope = new ArrayList<LinkedHashMap<String, ArrayList<String>>>();
                        securityScope.add(scopes);
                        methodSpec.put("security", securityScope);
                    }
                }
            });
        });
    }

    private Map<String, Object> createSecuritySchema(Configuration.Authorizer authorizer) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> authorizerInfo = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> configuration = new LinkedHashMap<String, Object>();
        ret.put("type", authorizer.getAuthorizationType());
        ret.put("flows", new HashMap<Object, Object>(authorizer.getFlows()));
        ret.put("x-amazon-apigateway-authorizer", authorizerInfo);
        authorizerInfo.put("identitySource", authorizer.getIdentitySource());
        authorizerInfo.put("type", authorizer.getType());
        authorizerInfo.put("jwtConfiguration", configuration);
        configuration.put("audience", new ArrayList<String>(authorizer.getAudience()));
        configuration.put("issuer", authorizer.getIssuer());
        return ret;
    }

    private Map<String, Object> castToMap(Object obj, String location) {
        if (obj != null) {
            try {
                Map ret = (Map)obj;
                this.checkOnlyStrings(ret.keySet(), location);
                return ret;
            }
            catch (ClassCastException cex) {
                throw O4A_Exception.invalidType(location);
            }
        }
        return new LinkedHashMap<String, Object>();
    }

    private List<String> castToList(Object obj, String location) {
        if (obj != null) {
            try {
                List ret = (List)obj;
                this.checkOnlyStrings(ret, location);
                return ret;
            }
            catch (ClassCastException cex) {
                throw O4A_Exception.invalidType(location);
            }
        }
        return new ArrayList<String>();
    }

    private void checkOnlyStrings(Collection<?> x, String location) {
        x.forEach(k -> {
            if (!(k instanceof String)) {
                throw new O4A_Exception("unexpected openapi content on " + location + ":" + k);
            }
        });
    }

    private Map<String, Object> getMap(Map<String, Object> specification, String path) {
        return this.castToMap(specification.computeIfAbsent(path, x -> new LinkedHashMap()), path + "path");
    }
}

