/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.coderazzi.openapi4aws.Configuration;
import net.coderazzi.openapi4aws.cli.AuthorizerParameter;
import net.coderazzi.openapi4aws.cli.CliException;
import net.coderazzi.openapi4aws.cli.IntegrationParameter;

class CliParser
extends Configuration {
    private static final Map<String, MainConsumer> argumentHandlers = new HashMap<String, MainConsumer>();
    private static final Map<String, AuthorizerConsumer> authorizerConsumers = new HashMap<String, AuthorizerConsumer>();
    private static final Map<String, Getter<AuthorizerParameter>> authorizerCheckers = new HashMap<String, Getter<AuthorizerParameter>>();
    private static final String AUTHORIZER = "authorizer.";
    private static final String AUTHORIZER_IDENTITY_SOURCE = "identity-source";
    private static final String AUTHORIZER_ISSUER = "issuer";
    private static final String AUTHORIZER_AUDIENCES = "audience";
    private static final String AUTHORIZER_AUTHORIZATION_TYPE = "authorization-type";
    private static final String AUTHORIZER_TYPE = "authorizer-type";
    private static final String TAG = "tag.";
    private static final String PATH = "path.";
    private static final String FILENAME = "filename";
    private static final String GLOB = "glob";
    private static final String OUTPUT = "output-folder";
    private final Map<String, AuthorizerParameter> authorizers = new LinkedHashMap<String, AuthorizerParameter>();
    private final Map<String, IntegrationParameter> tags = new HashMap<String, IntegrationParameter>();
    private final Map<String, IntegrationParameter> paths = new HashMap<String, IntegrationParameter>();
    private final Set<String> filenames = new HashSet<String>();
    private final Set<String> globs = new HashSet<String>();
    private Path outputFolder;

    public CliParser(String[] args) {
        Pattern p = Pattern.compile(String.format("^(?:--)?(%s)([^=]*)=(.+)$", String.join((CharSequence)"|", argumentHandlers.keySet())));
        for (String arg : args) {
            try {
                String value;
                String type;
                String area;
                block8: {
                    block7: {
                        Matcher m = p.matcher(arg);
                        if (!m.matches()) break block7;
                        area = m.group(1);
                        type = m.group(2).trim();
                        value = m.group(3).trim();
                        if (!value.isEmpty()) break block8;
                    }
                    throw CliException.unexpectedArgument();
                }
                argumentHandlers.get(area).consume(this, type, value);
            }
            catch (CliException ex) {
                throw new CliException(arg + " : " + ex.getMessage());
            }
        }
        if (this.filenames.isEmpty() && this.globs.isEmpty()) {
            throw new CliException("Missing filename or glob");
        }
        this.authorizers.forEach((name, instance) -> {
            if (!name.isEmpty()) {
                authorizerCheckers.forEach((prop, checker) -> {
                    if (null == checker.get(instance)) {
                        String missing = AUTHORIZER + prop;
                        throw new CliException("Missing " + missing + " or " + missing + "." + name);
                    }
                });
            }
        });
    }

    private static List<String> convertToNonEmptyList(String arg) {
        String[] split = arg.split(",");
        ArrayList<String> ret = new ArrayList<String>(split.length);
        for (String each : split) {
            String trimmed = each.trim();
            if (trimmed.isEmpty()) continue;
            ret.add(trimmed);
        }
        if (ret.isEmpty()) {
            throw new CliException("invalid value: " + arg);
        }
        return ret;
    }

    @Override
    public Map<String, Configuration.Authorizer> getAuthorizers() {
        return this.authorizers.entrySet().stream().filter(x -> !((String)x.getKey()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Configuration.Integration getIntegration(String path, List<String> tags) {
        return this.getIntegration(path, tags, this.paths, this.tags);
    }

    public Collection<Path> getPaths() {
        return this.getPaths(this.filenames, this.globs);
    }

    public Path getOutputFolder() {
        return this.outputFolder;
    }

    private void handleOutput(String value, String definition) {
        if (!value.isEmpty()) {
            throw CliException.unexpectedArgument();
        }
        if (this.outputFolder != null) {
            throw CliException.duplicatedArgument();
        }
        this.outputFolder = Paths.get(definition, new String[0]);
    }

    private void handleFilename(String value, String definition) {
        this.handleInputList(value, definition, this.filenames);
    }

    private void handleGlob(String value, String definition) {
        this.handleInputList(value, definition, this.globs);
    }

    private void handleInputList(String value, String definition, Collection<String> target) {
        if (!value.isEmpty()) {
            throw CliException.unexpectedArgument();
        }
        target.add(definition);
    }

    private void handleTag(String definition, String value) {
        this.handleTagOrPath(this.tags, value, false, definition.toLowerCase(Locale.ROOT));
    }

    private void handlePath(String definition, String value) {
        this.handleTagOrPath(this.paths, value, true, "/" + definition.replace(".", "/"));
    }

    private void handleTagOrPath(Map<String, IntegrationParameter> map, String value, boolean isPath, String definition) {
        if (map.containsKey(definition)) {
            throw CliException.duplicatedArgument();
        }
        List<String> parts = CliParser.convertToNonEmptyList(value);
        IntegrationParameter integration = new IntegrationParameter(parts.get(0), isPath);
        if (parts.size() > 1) {
            String authorizerName = parts.get(1);
            if (this.authorizers.get(authorizerName) == null) {
                throw new CliException(authorizerName + " is not a provided authorizer name");
            }
            integration.setAuthorization(parts.get(1), parts.subList(2, parts.size()));
        }
        map.put(definition, integration);
    }

    private void handleAuthorizer(String definition, String value) {
        if ("name".equals(definition)) {
            if (!this.authorizers.isEmpty()) {
                throw CliException.duplicatedArgument();
            }
            AuthorizerParameter defaultAuthorizer = new AuthorizerParameter(null);
            this.authorizers.put("", defaultAuthorizer);
            CliParser.convertToNonEmptyList(value).forEach(x -> this.authorizers.put((String)x, new AuthorizerParameter(defaultAuthorizer)));
        } else {
            AuthorizerParameter authorizer;
            int last;
            String name = "";
            AuthorizerConsumer authorizerConsumer = authorizerConsumers.get(definition);
            if (authorizerConsumer == null && (last = definition.lastIndexOf(46)) != -1) {
                name = definition.substring(last + 1).trim();
                authorizerConsumer = authorizerConsumers.get(definition.substring(0, last).trim());
            }
            if ((authorizer = this.authorizers.get(name)) == null || authorizerConsumer == null) {
                throw CliException.unexpectedArgument();
            }
            authorizerConsumer.handle(authorizer, value);
        }
    }

    static {
        argumentHandlers.put(AUTHORIZER, CliParser::handleAuthorizer);
        argumentHandlers.put(TAG, CliParser::handleTag);
        argumentHandlers.put(PATH, CliParser::handlePath);
        argumentHandlers.put(FILENAME, CliParser::handleFilename);
        argumentHandlers.put(GLOB, CliParser::handleGlob);
        argumentHandlers.put(OUTPUT, CliParser::handleOutput);
        authorizerConsumers.put(AUTHORIZER_IDENTITY_SOURCE, AuthorizerParameter::setIdentitySource);
        authorizerConsumers.put(AUTHORIZER_ISSUER, AuthorizerParameter::setIssuer);
        authorizerConsumers.put(AUTHORIZER_AUDIENCES, (s, a) -> s.setAudiences(CliParser.convertToNonEmptyList(a)));
        authorizerConsumers.put(AUTHORIZER_AUTHORIZATION_TYPE, AuthorizerParameter::setAuthorizationType);
        authorizerConsumers.put(AUTHORIZER_TYPE, AuthorizerParameter::setType);
        authorizerCheckers.put(AUTHORIZER_IDENTITY_SOURCE, AuthorizerParameter::getIdentitySource);
        authorizerCheckers.put(AUTHORIZER_ISSUER, AuthorizerParameter::getIssuer);
        authorizerCheckers.put(AUTHORIZER_AUDIENCES, AuthorizerParameter::getAudience);
        authorizerCheckers.put(AUTHORIZER_AUTHORIZATION_TYPE, AuthorizerParameter::getAuthorizationType);
        authorizerCheckers.put(AUTHORIZER_TYPE, AuthorizerParameter::getType);
    }

    private static interface Getter<T> {
        public Object get(T var1);
    }

    private static interface AuthorizerConsumer {
        public void handle(AuthorizerParameter var1, String var2);
    }

    private static interface MainConsumer {
        public void consume(CliParser var1, String var2, String var3);
    }
}

