/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.coderazzi.openapi4aws.O4A_Exception;

public abstract class Configuration {
    public abstract Map<String, Authorizer> getAuthorizers();

    public abstract Integration getIntegration(String var1, List<String> var2);

    protected Collection<Path> getPaths(Collection<String> filenames, Collection<String> globs) {
        final HashSet<Path> ret = new HashSet<Path>();
        if (filenames != null) {
            filenames.forEach(x -> ret.add(Paths.get(x, new String[0])));
        }
        if (globs != null) {
            for (String each : globs) {
                try {
                    final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + each);
                    Files.walkFileTree(FileSystems.getDefault().getPath("", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            if (pathMatcher.matches(path)) {
                                ret.add(path);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iex) {
                    throw new O4A_Exception("IOError while looking for glob " + each + ": " + iex);
                }
            }
        }
        return ret;
    }

    protected Integration getIntegration(String path, List<String> pathTags, Map<String, ? extends Integration> paths, Map<String, ? extends Integration> lowerCaseTags) {
        Integration ret;
        block1: {
            String tag;
            ret = paths.get(path);
            if (ret != null) break block1;
            Iterator<String> iterator = pathTags.iterator();
            while (iterator.hasNext() && (ret = lowerCaseTags.get((tag = iterator.next()).toLowerCase(Locale.ROOT))) == null) {
            }
        }
        return ret;
    }

    public static interface Integration {
        public List<String> getScopes();

        public String getAuthorizer();

        public String getUri(String var1);
    }

    public static interface Authorizer {
        public String getIdentitySource();

        public String getIssuer();

        public List<String> getAudience();

        public Map<Object, Object> getFlows();

        public String getAuthorizationType();

        public String getType();
    }
}

