/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.coderazzi.openapi4aws.Configuration;
import net.coderazzi.openapi4aws.O4A_Exception;
import net.coderazzi.openapi4aws.Openapi4AWS;
import net.coderazzi.openapi4aws.cli.CliParser;
import net.coderazzi.openapi4aws.plugin.Authorizer;
import net.coderazzi.openapi4aws.plugin.ConfigurationAdapter;
import net.coderazzi.openapi4aws.plugin.Integration;
import net.coderazzi.openapi4aws.plugin.PathIntegration;
import net.coderazzi.openapi4aws.plugin.TagIntegration;
import net.coderazzi.openapi4aws.plugin.Transform;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class OpenApi4AwsMojo
extends AbstractMojo {
    @Parameter
    private final List<Authorizer> authorizers = new ArrayList<Authorizer>();
    @Parameter
    private final List<Integration> integrations = new ArrayList<Integration>();
    @Parameter
    private final List<Transform> transforms = new ArrayList<Transform>();
    @Parameter
    private final List<String> external = new ArrayList<String>();

    public void execute() throws MojoExecutionException {
        try {
            ArrayList<Task> tasks = new ArrayList<Task>();
            for (String each : this.external) {
                try {
                    CliParser parser = new CliParser(each);
                    this.addToList(this.authorizers, parser.getAuthorizers(), Authorizer::copyFrom);
                    this.addToList(this.integrations, parser.getPathIntegrations(), PathIntegration::copyFrom);
                    this.addToList(this.integrations, parser.getTagIntegrations(), TagIntegration::copyFrom);
                    tasks.add(new Task(parser.getPaths(), parser.getOutputFolder()));
                }
                catch (O4A_Exception iex) {
                    throw new MojoExecutionException("External file '" + each + "': " + iex.getMessage(), (Exception)((Object)iex));
                }
            }
            ConfigurationAdapter adapter = new ConfigurationAdapter(this.authorizers, this.integrations, this.getLog());
            Openapi4AWS openapi4AWS = new Openapi4AWS((Configuration)adapter);
            try {
                for (Transform t : this.transforms) {
                    String o = t.getOutputFolder();
                    tasks.add(new Task(adapter.getPaths(t), o == null ? null : Paths.get(o, new String[0])));
                }
            }
            catch (IOException io) {
                throw new MojoExecutionException(io.toString(), (Exception)io);
            }
            for (Task task : tasks) {
                openapi4AWS.handle(task.paths, task.outputFolder);
            }
        }
        catch (O4A_Exception iex) {
            throw new MojoExecutionException(iex.getMessage(), (Exception)((Object)iex));
        }
    }

    private <T, U extends T> void addToList(List<U> target, Map<String, T> newSources, Creator<T, U> creator) {
        newSources.entrySet().stream().map(x -> creator.create((String)x.getKey(), x.getValue())).forEachOrdered(target::add);
    }

    private static class Task {
        Collection<Path> paths;
        Path outputFolder;

        Task(Collection<Path> paths, Path outputFolder) {
            this.paths = paths;
            this.outputFolder = outputFolder;
        }
    }

    private static interface Creator<T, U> {
        public U create(String var1, T var2);
    }
}

