/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.coderazzi.openapi4aws.Configuration;
import net.coderazzi.openapi4aws.plugin.Authorizer;
import net.coderazzi.openapi4aws.plugin.ConfigurationParameter;
import net.coderazzi.openapi4aws.plugin.Integration;
import net.coderazzi.openapi4aws.plugin.PathIntegration;
import net.coderazzi.openapi4aws.plugin.TagIntegration;
import net.coderazzi.openapi4aws.plugin.Transform;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

class ConfigurationAdapter
extends Configuration {
    private final Map<String, Configuration.Authorizer> authorizers;
    private final Map<String, PathIntegration> pathIntegrations;
    private final Map<String, TagIntegration> tagIntegrations;
    private final Log log;

    ConfigurationAdapter(List<Authorizer> authorizers, List<Integration> integrations, Log log) throws MojoExecutionException {
        this.log = log;
        List pathIntegrations = integrations.stream().filter(item -> item instanceof PathIntegration).map(item -> (PathIntegration)item).collect(Collectors.toList());
        List tagIntegrations = integrations.stream().filter(item -> item instanceof TagIntegration).map(item -> (TagIntegration)item).collect(Collectors.toList());
        this.checkParametersList(authorizers, Authorizer::getName);
        this.checkParametersList(pathIntegrations, PathIntegration::getPath);
        this.checkParametersList(tagIntegrations, TagIntegration::getTag);
        this.authorizers = authorizers.stream().collect(Collectors.toMap(Authorizer::getName, Function.identity()));
        this.pathIntegrations = pathIntegrations.stream().collect(Collectors.toMap(PathIntegration::getPath, Function.identity()));
        this.tagIntegrations = tagIntegrations.stream().collect(Collectors.toMap(TagIntegration::getTag, Function.identity()));
    }

    public Map<String, Configuration.Authorizer> getAuthorizers() {
        return this.authorizers;
    }

    public Configuration.Integration getIntegration(String path, List<String> tags) {
        Configuration.Integration ret = this.getIntegration(path, tags, this.pathIntegrations, this.tagIntegrations);
        this.log.debug((CharSequence)String.format("integration for %s, with tags %s, returning %s", path, String.join((CharSequence)"/", tags), ret == null ? "null" : ret.getAuthorizer()));
        return ret;
    }

    public Collection<Path> getPaths(Transform transform) throws IOException {
        Collection ret = this.getPaths(transform.getInput(), transform.getGlobInput());
        if (ret.isEmpty()) {
            this.log.debug((CharSequence)"Transform defined no paths");
        } else {
            ret.forEach(x -> this.log.info((CharSequence)("Path to handle: " + x.toString())));
        }
        return ret;
    }

    private <T extends ConfigurationParameter> void checkParametersList(List<T> parameters, UniqueGetter<T> getter) throws MojoExecutionException {
        if (parameters != null) {
            HashSet<String> keys = new HashSet<String>();
            for (ConfigurationParameter each : parameters) {
                each.check();
                String key = getter.get(each);
                if (keys.add(key)) continue;
                ConfigurationParameter.throwException("Repeated " + each.getElementName() + " " + key);
            }
        }
    }

    private static interface UniqueGetter<T> {
        public String get(T var1);
    }
}

