/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.coderazzi.openapi4aws.Configuration;
import net.coderazzi.openapi4aws.plugin.ConfigurationParameter;
import org.apache.maven.plugin.MojoExecutionException;

public class Authorizer
extends ConfigurationParameter
implements Configuration.Authorizer {
    private static final String AUTHORIZATION_TYPE = "oauth2";
    private static final String TYPE = "jwt";
    private String name;
    private String identitySource;
    private String issuer;
    private List<String> audience;
    private String authorizationType = "oauth2";
    private String type = "jwt";

    static Authorizer copyFrom(String name, Configuration.Authorizer base) {
        Authorizer ret = new Authorizer();
        ret.name = name;
        ret.identitySource = base.getIdentitySource();
        ret.issuer = base.getIssuer();
        ret.audience = base.getAudience();
        ret.authorizationType = base.getAuthorizationType();
        ret.type = base.getType();
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentitySource() {
        return this.identitySource;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public String getAuthorizationType() {
        return this.authorizationType;
    }

    public String getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Map<Object, Object> getFlows() {
        return Collections.emptyMap();
    }

    @Override
    public void check() throws MojoExecutionException {
        this.requireField(this.name, "name");
        this.requireField(this.identitySource, "identity source");
        this.requireField(this.issuer, "issuer");
        this.requireField(this.audience, "audiences");
        if (this.audience.size() == 0) {
            Authorizer.throwException("Authorizer definition does not include any audience values");
        }
        this.requireValue(this.authorizationType, AUTHORIZATION_TYPE, "authorization type");
        this.requireValue(this.type, TYPE, "type");
    }
}

