/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.ShouldChain;
import net.codestory.simplelenium.filters.Failure;
import net.codestory.simplelenium.filters.LazyDomElement;
import net.codestory.simplelenium.filters.Retry;
import net.codestory.simplelenium.filters.WebElementHelper;
import net.codestory.simplelenium.selectors.ByCssSelectorOrByNameOrById;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

class LazyShould
implements ShouldChain {
    private final LazyDomElement element;
    private final Retry retry;
    private final boolean ok;

    LazyShould(LazyDomElement element, Retry retry, boolean ok) {
        this.element = element;
        this.retry = retry;
        this.ok = ok;
    }

    @Override
    public DomElement find(String selector) {
        if (this.element.parent() != null) {
            return this.element.parent().find(selector);
        }
        return new LazyDomElement(new ByCssSelectorOrByNameOrById(selector));
    }

    @Override
    public DomElement find(By selector) {
        if (this.element.parent() != null) {
            return this.element.parent().find(selector);
        }
        return new LazyDomElement(selector);
    }

    @Override
    public LazyShould within(long duration, TimeUnit timeUnit) {
        return new LazyShould(this.element, new Retry(duration, timeUnit), this.ok);
    }

    @Override
    public LazyShould not() {
        return new LazyShould(this.element, this.retry, !this.ok);
    }

    @Override
    public LazyShould and() {
        return this;
    }

    @Override
    public LazyShould should() {
        return this;
    }

    @Override
    public LazyShould contain(String ... texts) {
        return this.verify(this.doesOrNot("contain") + " (" + String.join((CharSequence)";", texts) + ")", elements -> Stream.of(texts).allMatch(expected -> elements.stream().anyMatch(element -> WebElementHelper.text(element).contains((CharSequence)expected))), elements -> "It contains " + LazyShould.statuses(elements, element -> WebElementHelper.text(element)));
    }

    @Override
    public LazyShould beEmpty() {
        return this.verify(this.isOrNot("empty"), elements -> !elements.isEmpty() && elements.stream().allMatch(element -> WebElementHelper.text(element).isEmpty()), elements -> "It contains " + LazyShould.statuses(elements, element -> WebElementHelper.text(element)));
    }

    @Override
    public LazyShould match(Pattern regexp) {
        return this.verify(this.doesOrNot("match") + " (" + regexp.pattern() + ")", elements -> !elements.isEmpty() && elements.stream().anyMatch(element -> regexp.matcher(WebElementHelper.text(element)).matches()), elements -> "It contains " + LazyShould.statuses(elements, element -> WebElementHelper.text(element)));
    }

    @Override
    public LazyShould beEnabled() {
        return this.verify(this.isOrNot("enabled"), elements -> !elements.isEmpty() && elements.stream().allMatch(element -> element.isEnabled()), elements -> "It is " + LazyShould.statuses(elements, element -> LazyShould.enabledStatus(element)));
    }

    @Override
    public LazyShould beDisplayed() {
        return this.verify(this.isOrNot("displayed"), elements -> !elements.isEmpty() && elements.stream().allMatch(element -> element.isDisplayed()), elements -> "It is " + LazyShould.statuses(elements, element -> LazyShould.displayedStatus(element)));
    }

    @Override
    public LazyShould beSelected() {
        return this.verify(this.isOrNot("selected"), elements -> !elements.isEmpty() && elements.stream().allMatch(element -> LazyShould.isSelected(element)), elements -> "It is " + LazyShould.statuses(elements, element -> LazyShould.selectedStatus(element)));
    }

    @Override
    public LazyShould haveLessItemsThan(int maxCount) {
        return this.verify(this.doesOrNot("contain") + " less than " + Text.plural(maxCount, "element"), elements -> elements.size() < maxCount, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    @Override
    public LazyShould haveSize(int size) {
        return this.verify(this.doesOrNot("contain") + " " + Text.plural(size, "element"), elements -> elements.size() == size, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    @Override
    public LazyShould haveMoreItemsThan(int minCount) {
        return this.verify(this.doesOrNot("contain") + " more than " + Text.plural(minCount, "element"), elements -> elements.size() > minCount, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    @Override
    public LazyShould exist() {
        return this.verify(this.doesOrNot("exist"), elements -> !elements.isEmpty(), elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    @Override
    public LazyShould haveDimension(int width, int height) {
        return this.verify(this.hasOrNot("dimension"), elements -> !elements.isEmpty() && elements.stream().allMatch(element -> LazyShould.hasDimension(element, width, height)), elements -> "It measures " + LazyShould.statuses(elements, element -> LazyShould.dimension(element)));
    }

    @Override
    public LazyShould beAtLocation(int x, int y) {
        return this.verify(this.isOrNot("at location"), elements -> !elements.isEmpty() && elements.stream().allMatch(element -> LazyShould.hasLocation(element, x, y)), elements -> "It is at location " + LazyShould.statuses(elements, element -> LazyShould.location(element)));
    }

    @Override
    public LazyShould match(Predicate<WebElement> condition) {
        return this.verify(this.doesOrNot("match") + " (" + condition + ")", elements -> !elements.isEmpty() && elements.stream().allMatch(condition), elements -> "It is  " + LazyShould.statuses(elements, element -> Boolean.toString(condition.test((WebElement)element))));
    }

    private LazyShould verify(String message, Predicate<List<WebElement>> predicate, Function<List<WebElement>, String> toErrorMessage) {
        String verification = "verify that " + this.element + " " + message;
        System.out.println("   -> " + verification);
        try {
            if (!this.retry.verify(() -> this.findElements(), this.ok ? predicate : predicate.negate())) {
                throw Failure.create("Failed to " + verification + ". " + toErrorMessage.apply(this.findElements()));
            }
        }
        catch (NoSuchElementException e) {
            throw Failure.create("Element not found. Failed to " + verification);
        }
        return this.ok ? this : this.not();
    }

    private List<WebElement> findElements() {
        return this.element.stream().collect(Collectors.toList());
    }

    private String doesOrNot(String verb) {
        return Text.doesOrNot(!this.ok, verb);
    }

    private String isOrNot(String state) {
        return Text.isOrNot(!this.ok, state);
    }

    private String hasOrNot(String what) {
        return Text.hasOrNot(!this.ok, what);
    }

    private static boolean hasDimension(WebElement element, int width, int height) {
        Dimension dimension = element.getSize();
        return dimension.getWidth() == width && dimension.getHeight() == height;
    }

    private static boolean hasLocation(WebElement element, int x, int y) {
        Point location = element.getLocation();
        return location.getX() == x && location.getY() == y;
    }

    private static boolean isSelected(WebElement element) {
        return LazyShould.isSelectable(element) && element.isSelected();
    }

    private static String statuses(List<WebElement> elements, Function<WebElement, String> toStatus) {
        return elements.stream().map(toStatus).collect(Collectors.joining(";", "(", ")"));
    }

    private static String enabledStatus(WebElement element) {
        return element.isEnabled() ? "enabled" : "not enabled";
    }

    private static String displayedStatus(WebElement element) {
        return element.isDisplayed() ? "displayed" : "not displayed";
    }

    private static String dimension(WebElement element) {
        return element.getSize().toString();
    }

    private static String location(WebElement element) {
        return element.getLocation().toString();
    }

    private static String selectedStatus(WebElement element) {
        return LazyShould.isSelectable(element) ? (element.isSelected() ? "selected" : "not selected") : "not selectable";
    }

    private static boolean isSelectable(WebElement element) {
        return element.getTagName().equals("input") || element.getTagName().equals("option");
    }
}

