/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver.phantomjs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.codestory.simplelenium.driver.Configuration;
import net.codestory.simplelenium.driver.Downloader;
import net.codestory.simplelenium.driver.LockFile;
import net.codestory.simplelenium.driver.phantomjs.PhantomJSDriver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class PhantomJsDownloader
extends Downloader {
    public PhantomJsDownloader() {
        this(4, 4);
    }

    protected PhantomJsDownloader(int retryDownload, int retryConnect) {
        super(retryConnect, retryDownload);
    }

    public PhantomJSDriver createNewDriver(Capabilities desiredCapabilities) {
        System.out.println("Create a new PhantomJSDriver");
        File phantomJsExe = null;
        IllegalStateException downloadError = null;
        for (int i = this.retryDownload; i >= 0; --i) {
            try {
                phantomJsExe = this.downloadAndExtract();
                break;
            }
            catch (IllegalStateException e) {
                downloadError = e;
                if (i == 0) continue;
                System.err.println("Unable to download PhantomJS " + downloadError);
                this.pause(5L);
                continue;
            }
        }
        if (phantomJsExe == null) {
            throw new IllegalStateException("Unable to download PhantomJS", downloadError);
        }
        UnreachableBrowserException connectError = null;
        for (int i = this.retryConnect; i >= 0; --i) {
            try {
                return this.createNewPhantomJsDriver(phantomJsExe, desiredCapabilities);
            }
            catch (UnreachableBrowserException e) {
                connectError = e;
                if (i == 0) continue;
                System.err.println("Unable to start PhantomJS " + (Object)((Object)connectError));
                this.pause(5L);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start PhantomJS", connectError);
    }

    protected PhantomJSDriver createNewPhantomJsDriver(File phantomJsExe, Capabilities desiredCapabilities) {
        try {
            URL url = new URL("http://localhost:" + PortProber.findFreePort());
            return new PhantomJSDriver(phantomJsExe, url, new File("target/phantomjs.log"), desiredCapabilities);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File downloadAndExtract() {
        File installDir = new File(Configuration.USER_HOME.get(), ".phantomjstest");
        installDir.mkdirs();
        LockFile lock = new LockFile(new File(installDir, "lock"));
        lock.waitLock();
        try {
            File phantomJsExe;
            String url;
            if (this.isCustomized()) {
                url = Configuration.PHANTOMJS_URL.get();
                phantomJsExe = new File(installDir, Configuration.PHANTOMJS_EXE.get());
            } else if (this.isWindows()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-2.1.1-windows.zip";
                phantomJsExe = new File(installDir, "phantomjs-2.1.1-windows/phantomjs.exe");
            } else if (this.isMac()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-2.1.1-macosx.zip";
                phantomJsExe = new File(installDir, "phantomjs-2.1.1-macosx/bin/phantomjs");
            } else if (this.isLinux32()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-2.1.1-linux-i686.tar.bz2";
                phantomJsExe = new File(installDir, "phantomjs-2.1.1-linux-i686/bin/phantomjs");
            } else {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-2.1.1-linux-x86_64.tar.bz2";
                phantomJsExe = new File(installDir, "phantomjs-2.1.1-linux-x86_64/bin/phantomjs");
            }
            this.extractExe("phantomJs", url, installDir, phantomJsExe);
            File file = phantomJsExe;
            return file;
        }
        finally {
            lock.release();
        }
    }

    protected boolean isCustomized() {
        return Configuration.PHANTOMJS_URL.get() != null && Configuration.PHANTOMJS_EXE.get() != null;
    }
}

