/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver.phantomjs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.codestory.simplelenium.driver.SeleniumDriver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class PhantomJSDriver
extends RemoteWebDriver
implements SeleniumDriver {
    public PhantomJSDriver(File phantomJsExe, URL url, File logFile, Capabilities desiredCapabilities) {
        super((CommandExecutor)new PhantomJSHttpCommandExecutor(phantomJsExe, url, logFile), (Capabilities)DesiredCapabilities.phantomjs().merge(desiredCapabilities));
    }

    static class PhantomJSHttpCommandExecutor
    extends HttpCommandExecutor {
        private final URL url;
        private final CommandLine process;

        PhantomJSHttpCommandExecutor(File phantomJsExe, URL url, File logFile) {
            super(Collections.singletonMap("executePhantomScript", new CommandInfo("/session/:sessionId/phantom/execute", HttpMethod.POST)), url);
            this.url = url;
            this.process = new CommandLine(phantomJsExe.getPath(), new String[]{"--webdriver=" + url.getPort(), "--webdriver-logfile=" + logFile.getAbsolutePath()});
        }

        public Response execute(Command command) throws IOException {
            if ("newSession".equals(command.getName())) {
                this.start();
            }
            try {
                Response response = super.execute(command);
                return response;
            }
            catch (IOException | Error | RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new WebDriverException(t);
            }
            finally {
                if ("quit".equals(command.getName())) {
                    this.stop();
                }
            }
        }

        private void start() throws IOException {
            try {
                this.process.executeAsync();
                new UrlChecker().waitUntilAvailable(20L, TimeUnit.SECONDS, new URL[]{new URL(this.url + "/status")});
            }
            catch (UrlChecker.TimeoutException e) {
                this.process.checkForError();
                throw new WebDriverException("Driver failed to start.", (Throwable)e);
            }
        }

        private void stop() throws IOException {
            try {
                new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, new URL(this.url + "/shutdown"));
                this.process.destroy();
            }
            catch (UrlChecker.TimeoutException e) {
                throw new WebDriverException("Driver failed to stop.", (Throwable)e);
            }
        }
    }
}

