/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver.chrome;

import java.io.File;
import java.util.Collections;
import net.codestory.simplelenium.driver.Configuration;
import net.codestory.simplelenium.driver.Downloader;
import net.codestory.simplelenium.driver.LockFile;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class ChromeDriverDownloader
extends Downloader {
    public ChromeDriverDownloader() {
        this(4, 4);
    }

    protected ChromeDriverDownloader(int retryDownload, int retryConnect) {
        super(retryConnect, retryDownload);
    }

    public ChromeDriver createNewDriver(Capabilities desiredCapabilities) {
        System.out.println("Create a new ChromeDriver");
        File chromeDriverExe = null;
        IllegalStateException downloadError = null;
        for (int i = this.retryDownload; i >= 0; --i) {
            try {
                chromeDriverExe = this.downloadAndExtract();
                break;
            }
            catch (IllegalStateException e) {
                downloadError = e;
                if (i == 0) continue;
                System.err.println("Unable to download ChromeDriver " + downloadError);
                this.pause(5L);
                continue;
            }
        }
        if (chromeDriverExe == null) {
            throw new IllegalStateException("Unable to download ChromeDriver", downloadError);
        }
        UnreachableBrowserException connectError = null;
        for (int i = this.retryConnect; i >= 0; --i) {
            try {
                return this.createNewChromeDriver(chromeDriverExe, desiredCapabilities);
            }
            catch (UnreachableBrowserException e) {
                connectError = e;
                if (i == 0) continue;
                System.err.println("Unable to start ChromeDriver " + (Object)((Object)connectError));
                this.pause(5L);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start ChromeDriver", connectError);
    }

    protected ChromeDriver createNewChromeDriver(File chromeDriverExe, Capabilities desiredCapabilities) {
        ChromeDriverService chromeDriverService = (ChromeDriverService)((ChromeDriverService.Builder)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingDriverExecutable(chromeDriverExe)).usingPort(Configuration.CHROMEDRIVER_PORT.getInt())).build();
        DesiredCapabilities capabilities = new DesiredCapabilities(Collections.singletonMap("chromeOptions", this.getChromeOptions())).merge(desiredCapabilities);
        return new ChromeDriver(chromeDriverService, (Capabilities)capabilities);
    }

    protected ChromeOptions getChromeOptions() {
        File chromeInstalledByHomebrew;
        ChromeOptions options = new ChromeOptions();
        if (this.isMac() && (chromeInstalledByHomebrew = new File("/opt/homebrew-cask/Caskroom/google-chrome/latest/Google Chrome.app/Contents/MacOS/Google Chrome")).exists()) {
            options.setBinary(chromeInstalledByHomebrew);
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File downloadAndExtract() {
        File installDir = new File(Configuration.USER_HOME.get(), ".chromdrivertest");
        installDir.mkdirs();
        LockFile lock = new LockFile(new File(installDir, "lock"));
        lock.waitLock();
        try {
            File chromeDriverExe;
            String url;
            if (this.isCustomized()) {
                url = Configuration.CHROMEDRIVER_URL.get();
                chromeDriverExe = new File(installDir, Configuration.CHROMEDRIVER_EXE.get());
            } else if (this.isWindows()) {
                url = "https://chromedriver.storage.googleapis.com/2.19/chromedriver_win32.zip";
                chromeDriverExe = new File(installDir, "chromedriver.exe");
            } else if (this.isMac()) {
                url = "https://chromedriver.storage.googleapis.com/2.19/chromedriver_mac32.zip";
                chromeDriverExe = new File(installDir, "chromedriver");
            } else if (this.isLinux32()) {
                url = "https://chromedriver.storage.googleapis.com/2.19/chromedriver_linux32.zip";
                chromeDriverExe = new File(installDir, "chromedriver");
            } else {
                url = "https://chromedriver.storage.googleapis.com/2.19/chromedriver_linux64.zip";
                chromeDriverExe = new File(installDir, "chromedriver");
            }
            this.extractExe("chromeDriver", url, installDir, chromeDriverExe);
            File file = chromeDriverExe;
            return file;
        }
        finally {
            lock.release();
        }
    }

    protected boolean isCustomized() {
        return Configuration.CHROMEDRIVER_URL.get() != null && Configuration.CHROMEDRIVER_EXE.get() != null;
    }
}

