/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver;

public enum Configuration {
    BROWSER("browser", "PHANTOM_JS", false),
    CHROMEDRIVER_URL("chromedriver.url", null, false),
    CHROMEDRIVER_EXE("chromedriver.exe", null, false),
    CHROMEDRIVER_PORT("chromedriver.port", "0", false),
    PHANTOMJS_URL("phantomjs.url", null, false),
    PHANTOMJS_EXE("phantomjs.exe", null, false),
    USER_HOME("user.home", null, true),
    OS_NAME("os.name", null, true);

    private final String key;
    private final String defaultValue;
    private final boolean required;

    private Configuration(String key, String defaultValue, boolean required) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.required = required;
    }

    public int getInt() {
        return Integer.parseInt(this.get());
    }

    public String get() {
        String value = System.getProperty(this.key);
        if (value == null || value.trim().isEmpty()) {
            if (this.required) {
                throw new IllegalArgumentException("System property [" + this.key + "] cannot be null nor empty");
            }
            return this.defaultValue;
        }
        return value;
    }
}

