/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver;

import java.util.function.Function;
import java.util.stream.Stream;
import net.codestory.simplelenium.driver.Configuration;
import net.codestory.simplelenium.driver.SeleniumDriver;
import net.codestory.simplelenium.driver.ThreadSafeDriver;
import net.codestory.simplelenium.driver.chrome.ChromeDriverDownloader;
import net.codestory.simplelenium.driver.phantomjs.PhantomJsDownloader;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public enum Browser {
    PHANTOM_JS(capabilities -> new PhantomJsDownloader().createNewDriver((Capabilities)capabilities)),
    CHROME(capabilities -> new ChromeDriverDownloader().createNewDriver((Capabilities)capabilities)),
    FIREFOX(capabilities -> new FirefoxDriver(capabilities));

    private final Function<Capabilities, RemoteWebDriver> driverSupplier;
    private final ThreadLocal<SeleniumDriver> perThreadDriver = new ThreadLocal<SeleniumDriver>(){

        @Override
        protected SeleniumDriver initialValue() {
            Capabilities capabilities = Browser.this.getDesiredCapabilities();
            RemoteWebDriver webDriver = (RemoteWebDriver)Browser.this.driverSupplier.apply(capabilities);
            return ThreadSafeDriver.makeThreadSafe(webDriver);
        }
    };
    private Capabilities desiredCapabilities;

    private Browser(Function<Capabilities, RemoteWebDriver> driverSupplier) {
        this.driverSupplier = driverSupplier;
    }

    public void setDesiredCapabilities(Capabilities desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }

    public Capabilities getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public SeleniumDriver getDriverForThread() {
        return this.perThreadDriver.get();
    }

    public static Browser getCurrentBrowser() {
        String browserName = Configuration.BROWSER.get();
        return Stream.of(Browser.values()).filter(browser -> browser.name().equalsIgnoreCase(browserName)).findFirst().orElseThrow(() -> new IllegalStateException("No selenium driver for " + browserName));
    }

    public static SeleniumDriver getCurrentDriver() {
        return Browser.getCurrentBrowser().getDriverForThread();
    }
}

