/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.function.Function;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.SectionObject;
import net.codestory.simplelenium.filters.LazyDomElement;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static void injectMissingPageObjects(Object instance) {
        ReflectionUtil.injectNullFieldsOfType(SectionObject.class, instance, field -> {
            SectionObject pageObject = (SectionObject)ReflectionUtil.newInstance(field.getType());
            ReflectionUtil.injectMissingElements(pageObject);
            return pageObject;
        });
    }

    public static void injectMissingElements(Object pageObject) {
        ReflectionUtil.injectMissingPageObjects(pageObject);
        ReflectionUtil.injectNullFieldsOfType(DomElement.class, pageObject, field -> new LazyDomElement((By)new ByIdOrName(field.getName())));
        ReflectionUtil.injectNullFieldsWithConstructorParameterOfType(DomElement.class, pageObject, field -> new LazyDomElement((By)new ByIdOrName(field.getName())));
    }

    public static <T> void injectNullFieldsOfType(Class<T> type, Object target, Function<Field, T> factory) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                if (field.get(target) != null) continue;
                field.set(target, factory.apply(field));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Unable to set field [%s] on instance of type [%s]", field.getName(), target.getClass().getName()));
            }
        }
    }

    public static <T> void injectNullFieldsWithConstructorParameterOfType(Class<T> type, Object target, Function<Field, T> factory) {
        for (Field field : target.getClass().getDeclaredFields()) {
            try {
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                if (field.get(target) != null) continue;
                Constructor<?> constructor = field.getType().getDeclaredConstructor(type);
                constructor.setAccessible(true);
                field.set(target, constructor.newInstance(factory.apply(field)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("Unable to set field [%s] on instance of type [%s]", field.getName(), target.getClass().getName()));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static <T> T newInstance(Class<T> type) {
        T instance;
        Constructor<T> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Couldn't create Page Object. Missing 0 arg constructor on type " + type, e);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create instance of type " + type, e);
        }
        return instance;
    }
}

