/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public abstract class Downloader {
    protected static final int DEFAULT_RETRY_DOWNLOAD = 4;
    protected static final int DEFAULT_RETRY_CONNECT = 4;
    protected final int retryDownload;
    protected final int retryConnect;

    public Downloader(int retryConnect, int retryDownload) {
        this.retryConnect = retryConnect;
        this.retryDownload = retryDownload;
    }

    protected void pause(long timeout) {
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void extractExe(String driverName, String url, File installDirectory, File executable) {
        if (executable.exists()) {
            return;
        }
        String zipName = url.substring(url.lastIndexOf(47) + 1);
        File targetZip = new File(installDirectory, zipName);
        this.downloadZip(driverName, url, targetZip);
        System.out.println("Extracting " + driverName);
        try {
            if (url.endsWith(".zip")) {
                this.unzip(targetZip, installDirectory);
            } else {
                this.untarbz2(targetZip, installDirectory);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to uncompress " + driverName + " from " + targetZip.getAbsolutePath(), e);
        }
        executable.setExecutable(true);
    }

    protected void downloadZip(String driverName, String url, File targetZip) {
        if (targetZip.exists()) {
            if (targetZip.length() > 0L) {
                return;
            }
            targetZip.delete();
        }
        System.out.printf("Downloading %s from %s...%n", driverName, url);
        File zipTemp = new File(targetZip.getAbsolutePath() + ".temp");
        zipTemp.getParentFile().mkdirs();
        try (InputStream input = URI.create(url).toURL().openStream();){
            Files.copy(input, zipTemp.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to download " + driverName + " from " + url + " to " + targetZip, e);
        }
        if (!zipTemp.renameTo(targetZip)) {
            throw new IllegalStateException(String.format("Unable to rename %s to %s", zipTemp.getAbsolutePath(), targetZip.getAbsolutePath()));
        }
    }

    protected void untarbz2(File zip, File toDir) throws IOException {
        File tar = new File(zip.getAbsolutePath().replace(".tar.bz2", ".tar"));
        try (FileInputStream fin = new FileInputStream(zip);
             BufferedInputStream bin = new BufferedInputStream(fin);
             BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream((InputStream)bin);){
            Files.copy((InputStream)bzIn, tar.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.untar(tar, toDir);
    }

    protected void unzip(File zip, File toDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File to = new File(toDir, entry.getName());
                File parent = to.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Unable to create folder " + parent);
                }
                InputStream input = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    Files.copy(input, to.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
        }
    }

    protected void untar(File tar, File toDir) throws IOException {
        try (FileInputStream fin = new FileInputStream(tar);
             BufferedInputStream bin = new BufferedInputStream(fin);
             TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)bin);){
            TarArchiveEntry entry;
            while (null != (entry = tarInput.getNextTarEntry())) {
                if (entry.isDirectory()) continue;
                File to = new File(toDir, entry.getName());
                File parent = to.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Unable to create folder " + parent);
                }
                Files.copy((InputStream)tarInput, to.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    protected boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    protected boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    protected boolean isLinux32() {
        return System.getProperty("os.name").contains("x86");
    }
}

