/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.PhantomJsDownloader;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public abstract class SeleniumTest {
    private static final PhantomJsDownloader phantomJsDownloader = new PhantomJsDownloader();
    private final WebDriver driver = this.createWebDriver();
    public TestWatcher printTestName = new TestWatcher(){

        protected void starting(Description desc) {
            System.out.println("-----------------------------------------");
            System.out.println(desc.getTestClass().getSimpleName() + "." + desc.getMethodName());
            System.out.println("-----------------------------------------");
        }
    };
    public TestWatcher takeSnapshot = new TestWatcher(){

        protected void failed(Throwable e, Description desc) {
            if (SeleniumTest.this.driver == null) {
                return;
            }
            try {
                byte[] snapshotData = (byte[])((TakesScreenshot)SeleniumTest.this.driver).getScreenshotAs(OutputType.BYTES);
                File snapshot = new File("snapshots", desc.getTestClass().getSimpleName() + "_" + desc.getMethodName() + ".png");
                snapshot.getParentFile().mkdirs();
                Files.write((byte[])snapshotData, (File)snapshot);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to take snapshot", ioe);
            }
        }
    };
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.printTestName).around((TestRule)this.takeSnapshot);

    protected WebDriver createWebDriver() {
        WebDriver driver = phantomJsDownloader.getDriverForThread();
        driver.manage().window().setSize(new Dimension(2048, 768));
        return driver;
    }

    public abstract String getDefaultBaseUrl();

    public void goTo(String url) {
        System.out.println("goTo " + url);
        this.driver.get(this.getDefaultBaseUrl() + url);
        System.out.println(" - current url " + this.driver.getCurrentUrl());
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String currentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String title() {
        return this.driver.getTitle();
    }

    public String pageSource() {
        return this.driver.getPageSource();
    }

    public DomElement find(String selector) {
        return this.find(By.cssSelector((String)selector));
    }

    public DomElement find(By selector) {
        return new DomElement(this.driver, selector);
    }
}

