/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.codestory.simplelenium.Verification;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

class Retry {
    private long timeoutInMs;

    Retry(long duration, TimeUnit timeUnit) {
        this.timeoutInMs = timeUnit.toMillis(duration);
    }

    <T> void execute(Supplier<T> target, Consumer<T> action) {
        WebDriverException lastError = null;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeoutInMs) {
            try {
                action.accept(target.get());
                return;
            }
            catch (WebDriverException e) {
                lastError = e;
            }
        }
        throw lastError;
    }

    <T> Verification verify(Supplier<T> targetSupplier, Predicate<T> predicate) {
        Verification result = Verification.KO;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeoutInMs) {
            try {
                if (predicate.test(targetSupplier.get())) {
                    return Verification.OK;
                }
                result = Verification.KO;
            }
            catch (NotFoundException e) {
                result = Verification.NOT_FOUND;
            }
            catch (StaleElementReferenceException e) {}
        }
        return result;
    }
}

