/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver.phantomjs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.codestory.simplelenium.driver.Downloader;
import net.codestory.simplelenium.driver.LockFile;
import net.codestory.simplelenium.driver.phantomjs.PhantomJSDriver;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class PhantomJsDownloader
extends Downloader {
    public static final String PHANTOMJS_URL = "phantomjs.url";
    public static final String PHANTOMJS_EXE = "phantomjs.exe";

    public PhantomJsDownloader() {
        this(4, 4);
    }

    protected PhantomJsDownloader(int retryDownload, int retryConnect) {
        super(retryConnect, retryDownload);
    }

    public PhantomJSDriver createNewDriver() {
        System.out.println("Create a new PhantomJSDriver");
        File phantomJsExe = null;
        IllegalStateException downloadError = null;
        for (int i = this.retryDownload; i >= 0; --i) {
            try {
                phantomJsExe = this.downloadAndExtract();
                break;
            }
            catch (IllegalStateException e) {
                downloadError = e;
                if (i == 0) continue;
                System.err.println("Unable to download PhantomJS " + downloadError);
                this.pause(5L);
                continue;
            }
        }
        if (phantomJsExe == null) {
            throw new IllegalStateException("Unable to download PhantomJS", downloadError);
        }
        UnreachableBrowserException connectError = null;
        for (int i = this.retryConnect; i >= 0; --i) {
            try {
                return this.createNewPhantomJsDriver(phantomJsExe);
            }
            catch (UnreachableBrowserException e) {
                connectError = e;
                if (i == 0) continue;
                System.err.println("Unable to start PhantomJS " + (Object)((Object)connectError));
                this.pause(5L);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start PhantomJS", connectError);
    }

    protected PhantomJSDriver createNewPhantomJsDriver(File phantomJsExe) {
        try {
            URL url = new URL("http://localhost:" + PortProber.findFreePort());
            return new PhantomJSDriver(phantomJsExe, url, new File("target/phantomjs.log"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File downloadAndExtract() {
        File installDir = new File(new File(System.getProperty("user.home")), ".phantomjstest");
        installDir.mkdirs();
        LockFile lock = new LockFile(new File(installDir, "lock"));
        lock.waitLock();
        try {
            File phantomJsExe;
            String url;
            if (this.isCustomized()) {
                url = System.getProperty(PHANTOMJS_URL);
                phantomJsExe = new File(installDir, System.getProperty(PHANTOMJS_EXE));
            } else if (this.isWindows()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-windows.zip";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-windows/phantomjs.exe");
            } else if (this.isMac()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-macosx.zip";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-macosx/bin/phantomjs");
            } else if (this.isLinux32()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-linux-i686.tar.bz2";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-linux-i686/bin/phantomjs");
            } else {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-linux-x86_64.tar.bz2";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-linux-x86_64/bin/phantomjs");
            }
            this.extractExe("phantomJs", url, installDir, phantomJsExe);
            File file = phantomJsExe;
            return file;
        }
        finally {
            lock.release();
        }
    }

    protected boolean isCustomized() {
        return System.getProperty(PHANTOMJS_URL) != null && System.getProperty(PHANTOMJS_EXE) != null;
    }
}

