/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.codestory.simplelenium.driver.SeleniumDriver;
import net.codestory.simplelenium.driver.ThreadSafeDriver;
import net.codestory.simplelenium.driver.chrome.ChromeDriverDownloader;
import net.codestory.simplelenium.driver.phantomjs.PhantomJsDownloader;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public enum Browser {
    PHANTOM_JS(() -> new PhantomJsDownloader().createNewDriver()),
    CHROME(() -> new ChromeDriverDownloader().createNewDriver()),
    FIREFOX(FirefoxDriver::new);

    private final Supplier<RemoteWebDriver> driverSupplier;
    private final ThreadLocal<SeleniumDriver> perThreadDriver = new ThreadLocal<SeleniumDriver>(){

        @Override
        protected SeleniumDriver initialValue() {
            return ThreadSafeDriver.makeThreadSafe((RemoteWebDriver)Browser.this.driverSupplier.get());
        }
    };

    private Browser(Supplier<RemoteWebDriver> driverSupplier) {
        this.driverSupplier = driverSupplier;
    }

    public static Browser getCurrentBrowser() {
        String browserProperty = System.getProperty("browser");
        if (browserProperty == null || "".equals(browserProperty)) {
            return PHANTOM_JS;
        }
        return Stream.of(Browser.values()).filter(browser -> browser.name().equalsIgnoreCase(browserProperty)).findFirst().orElseThrow(() -> new IllegalStateException("No selenium driver for " + browserProperty));
    }

    public static SeleniumDriver getCurrentDriver() {
        return Browser.getCurrentBrowser().getDriverForThread();
    }

    public SeleniumDriver getDriverForThread() {
        return this.perThreadDriver.get();
    }
}

