/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

class Retry {
    public static final Retry _5_SECONDS = new Retry(5L, TimeUnit.SECONDS);
    public static final Retry _30_SECONDS = new Retry(30L, TimeUnit.SECONDS);
    private final long timeoutInMs;

    public Retry(long duration, TimeUnit timeUnit) {
        this.timeoutInMs = timeUnit.toMillis(duration);
    }

    <T> void execute(Supplier<Optional<T>> target, Consumer<T> action) {
        WebDriverException lastError = null;
        boolean retried = false;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeoutInMs) {
            try {
                Optional<T> targetElement = target.get();
                if (targetElement.isPresent()) {
                    action.accept(targetElement.get());
                    if (retried) {
                        System.out.println();
                    }
                    return;
                }
            }
            catch (StaleElementReferenceException targetElement) {
            }
            catch (WebDriverException e) {
                lastError = e;
            }
            retried = true;
            System.out.print(".");
        }
        if (retried) {
            System.out.println();
        }
        if (lastError != null) {
            throw lastError;
        }
        throw new NoSuchElementException("Not found");
    }

    <T> boolean verify(Supplier<T> targetSupplier, Predicate<T> predicate) throws NoSuchElementException {
        Error error = Error.KO;
        boolean retried = false;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeoutInMs) {
            try {
                if (predicate.test(targetSupplier.get())) {
                    if (retried) {
                        System.out.println();
                    }
                    return true;
                }
                error = Error.KO;
            }
            catch (InvalidElementStateException e) {
                error = Error.KO;
            }
            catch (NotFoundException e) {
                error = Error.NOT_FOUND;
            }
            catch (StaleElementReferenceException staleElementReferenceException) {
                // empty catch block
            }
            retried = true;
            System.out.print(".");
        }
        if (retried) {
            System.out.println();
        }
        if (error == Error.NOT_FOUND) {
            throw new NoSuchElementException("Not found");
        }
        return false;
    }

    static enum Error {
        NOT_FOUND,
        KO;

    }
}

