/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver.phantomjs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

class LockFile {
    private static final List<LockFile> LOCKS_TAKEN = new CopyOnWriteArrayList<LockFile>();
    private final File lockFile;
    private FileLock lock;

    LockFile(File lockFile) {
        this.lockFile = lockFile;
    }

    public void waitLock() {
        while (true) {
            try {
                this.lockFile.getParentFile().mkdirs();
                this.lock = new FileOutputStream(this.lockFile).getChannel().tryLock();
                if (this.lock != null) {
                    LOCKS_TAKEN.add(this);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LockFile.waitBeforeRetry();
        }
    }

    public void release() {
        Objects.requireNonNull(this.lock, "Lock before unlock");
        try {
            LOCKS_TAKEN.remove(this);
            this.lock.release();
            this.lockFile.delete();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to release lock");
        }
    }

    private static void waitBeforeRetry() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

