/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashSet;
import net.codestory.simplelenium.driver.SeleniumDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

class ThreadSafeDriver {
    private ThreadSafeDriver() {
    }

    static SeleniumDriver makeThreadSafe(RemoteWebDriver driver) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((RemoteWebDriver)driver).quit()));
        return (SeleniumDriver)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), ThreadSafeDriver.findInterfaces(driver), (proxy, method, args) -> {
            if (method.getName().equals("quit")) {
                return null;
            }
            try {
                return method.invoke((Object)driver, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        });
    }

    private static Class[] findInterfaces(Object driver) {
        LinkedHashSet<Class<SeleniumDriver>> interfaces = new LinkedHashSet<Class<SeleniumDriver>>();
        interfaces.add(SeleniumDriver.class);
        for (Class<?> parent = driver.getClass(); parent != null; parent = parent.getSuperclass()) {
            Collections.addAll(interfaces, parent.getInterfaces());
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }
}

