/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.codestory.simplelenium.CurrentWebDriver;
import net.codestory.simplelenium.DomElementFinder;
import net.codestory.simplelenium.PageObject;
import net.codestory.simplelenium.driver.SeleniumDriver;

public interface Navigation
extends DomElementFinder {
    public static final ThreadLocal<String> baseUrl = new ThreadLocal();

    public static String getBaseUrl() {
        return baseUrl.get();
    }

    public static void setBaseUrl(String url) {
        baseUrl.set(url);
    }

    default public SeleniumDriver driver() {
        return CurrentWebDriver.get();
    }

    default public List<String> console() {
        return this.driver().manage().logs().get("browser").getAll().stream().map(log -> log.getMessage().replace(" (undefined:undefined)", "")).collect(Collectors.toList());
    }

    default public Object executeJavascript(String javascriptCode, Object ... args) {
        return this.driver().executeScript(javascriptCode, args);
    }

    default public Navigation goTo(String url) {
        Objects.requireNonNull(url, "The url cannot be null");
        URI uri = URI.create(url);
        if (!uri.isAbsolute()) {
            url = Navigation.getBaseUrl() + url;
        }
        System.out.println("goTo " + url);
        this.driver().get(url);
        System.out.println(" - current url " + this.driver().getCurrentUrl());
        return this;
    }

    default public Navigation goTo(PageObject page) {
        this.goTo(page.url());
        return this;
    }
}

