/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.stream.Stream;
import net.codestory.simplelenium.driver.Browser;
import net.codestory.simplelenium.driver.SeleniumDriver;
import net.codestory.simplelenium.driver.ThreadSafeDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class CurrentWebDriver {
    private static final ThreadLocal<SeleniumDriver> perThreadDriver = new ThreadLocal<SeleniumDriver>(){

        @Override
        protected SeleniumDriver initialValue() {
            SeleniumDriver newDriver = CurrentWebDriver.getTargetBrowser().createNewDriver();
            return ThreadSafeDriver.makeThreadSafe((RemoteWebDriver)newDriver);
        }
    };

    public static Browser getTargetBrowser() {
        String browserProperty = System.getProperty("browser");
        return Stream.of(Browser.values()).filter(browser -> browser.name().equalsIgnoreCase(browserProperty)).findFirst().orElse(Browser.PHANTOM_JS);
    }

    public static SeleniumDriver get() {
        return perThreadDriver.get();
    }
}

