/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.driver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.codestory.simplelenium.driver.LockFile;
import net.codestory.simplelenium.driver.PhantomJSDriver;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class PhantomJsDownloader {
    private static final int DEFAULT_RETRY_DOWNLOAD = 4;
    private static final int DEFAULT_RETRY_CONNECT = 4;
    private final int retryDownload;
    private final int retryConnect;

    public PhantomJsDownloader() {
        this(4, 4);
    }

    protected PhantomJsDownloader(int retryDownload, int retryConnect) {
        this.retryDownload = retryDownload;
        this.retryConnect = retryConnect;
    }

    public PhantomJSDriver createNewDriver() {
        System.out.println("Create a new PhantomJSDriver");
        File phantomJsExe = null;
        IllegalStateException downloadError = null;
        for (int i = this.retryDownload; i >= 0; --i) {
            try {
                phantomJsExe = this.downloadAndExtract();
                break;
            }
            catch (IllegalStateException e) {
                downloadError = e;
                if (i == 0) continue;
                System.err.println("Unable to download PhantomJS " + downloadError);
                this.pause(5L);
                continue;
            }
        }
        if (phantomJsExe == null) {
            throw new IllegalStateException("Unable to download PhantomJS", downloadError);
        }
        UnreachableBrowserException connectError = null;
        for (int i = this.retryConnect; i >= 0; --i) {
            try {
                return this.createNewPhantomJsDriver(phantomJsExe);
            }
            catch (UnreachableBrowserException e) {
                connectError = e;
                if (i == 0) continue;
                System.err.println("Unable to start PhantomJS " + (Object)((Object)connectError));
                this.pause(5L);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start PhantomJS", connectError);
    }

    protected PhantomJSDriver createNewPhantomJsDriver(File phantomJsExe) {
        try {
            URL url = new URL("http://localhost:" + PortProber.findFreePort());
            return new PhantomJSDriver(phantomJsExe, url, new File("target/phantomjs.log"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void pause(long timeout) {
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File downloadAndExtract() {
        File installDir = new File(new File(System.getProperty("user.home")), ".phantomjstest");
        installDir.mkdirs();
        LockFile lock = new LockFile(new File(installDir, "lock"));
        lock.waitLock();
        try {
            File phantomJsExe;
            String url;
            if (this.isWindows()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-windows.zip";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-windows/phantomjs.exe");
            } else if (this.isMac()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-macosx.zip";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-macosx/bin/phantomjs");
            } else if (this.isLinux32()) {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-linux-i686.tar.bz2";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-linux-i686/bin/phantomjs");
            } else {
                url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.8-linux-x86_64.tar.bz2";
                phantomJsExe = new File(installDir, "phantomjs-1.9.8-linux-x86_64/bin/phantomjs");
            }
            this.extractExe(url, installDir, phantomJsExe);
            File file = phantomJsExe;
            return file;
        }
        finally {
            lock.release();
        }
    }

    protected void extractExe(String url, File phantomInstallDir, File phantomJsExe) {
        if (phantomJsExe.exists()) {
            return;
        }
        String zipName = url.substring(url.lastIndexOf(47) + 1);
        File targetZip = new File(phantomInstallDir, zipName);
        this.downloadZip(url, targetZip);
        System.out.println("Extracting phantomjs");
        try {
            if (this.isWindows() || this.isMac()) {
                this.unzip(targetZip, phantomInstallDir);
            } else {
                this.executeNative(phantomInstallDir, "tar", "xjvf", zipName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to unzip phantomjs from " + targetZip.getAbsolutePath(), e);
        }
        phantomJsExe.setExecutable(true);
    }

    protected void downloadZip(String url, File targetZip) {
        if (targetZip.exists()) {
            if (targetZip.length() == 0L) {
                targetZip.delete();
            } else {
                return;
            }
        }
        System.out.printf("Downloading phantomjs from %s...%n", url);
        File zipTemp = new File(targetZip.getAbsolutePath() + ".temp");
        zipTemp.getParentFile().mkdirs();
        try (InputStream input = URI.create(url).toURL().openStream();){
            Files.copy(input, zipTemp.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to download phantomjs from " + url + " to " + targetZip, e);
        }
        if (!zipTemp.renameTo(targetZip)) {
            throw new IllegalStateException(String.format("Unable to rename %s to %s", zipTemp.getAbsolutePath(), targetZip.getAbsolutePath()));
        }
    }

    protected void unzip(File zip, File toDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File to = new File(toDir, entry.getName());
                File parent = to.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Unable to create folder " + parent);
                }
                InputStream input = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    Files.copy(input, to.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
        }
    }

    protected void executeNative(File workingDir, String ... commands) throws IOException, InterruptedException {
        new ProcessBuilder(new String[0]).command(commands).directory(workingDir).start().waitFor();
    }

    protected boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    protected boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    protected boolean isLinux32() {
        return System.getProperty("os.name").contains("x86");
    }
}

