/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.rules;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.codestory.simplelenium.driver.CurrentWebDriver;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.OutputType;

public class TakeSnapshot
extends TestWatcher {
    private Class<?> testClass;
    private String methodName;

    protected void starting(Description description) {
        this.testClass = description.getTestClass();
        this.methodName = description.getMethodName();
    }

    protected void failed(Throwable e, Description description) {
        this.takeSnapshot();
    }

    public void takeSnapshot() {
        try {
            byte[] image = (byte[])CurrentWebDriver.get().getScreenshotAs(OutputType.BYTES);
            File file = this.snapshotPath(this.testClass, this.methodName);
            this.write(image, file);
            System.err.println("   !! A snapshot was taken here [" + file.getAbsolutePath() + "] to help you debug");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to take snapshot", ioe);
        }
    }

    protected void write(byte[] snapshotData, File to) throws IOException {
        to.getParentFile().mkdirs();
        Files.write(to.toPath(), snapshotData, new OpenOption[0]);
    }

    protected File snapshotPath(Class<?> testClass, String methodName) {
        return new File("snapshots", testClass.getSimpleName() + "_" + methodName + ".png");
    }
}

