/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.codestory.simplelenium.FilteredDomElement;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.filters.LazyDomElement;
import net.codestory.simplelenium.filters.StringPredicates;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.WebElement;

class ElementFilterBuilder
implements FilteredDomElement {
    private final LazyDomElement domElement;
    private final String description;
    private final Function<WebElement, String> toValue;
    private final boolean ok;

    ElementFilterBuilder(LazyDomElement domElement, String description, Function<WebElement, String> toValue, boolean ok) {
        this.domElement = domElement;
        this.description = description;
        this.toValue = toValue;
        this.ok = ok;
    }

    @Override
    public ElementFilterBuilder not() {
        return new ElementFilterBuilder(this.domElement, this.description, this.toValue, !this.ok);
    }

    @Override
    public LazyDomElement isEmpty() {
        return this.build(this.isOrNot("empty"), null, StringPredicates.isEmpty());
    }

    @Override
    public LazyDomElement isNull() {
        return this.build(this.isOrNot("null"), null, StringPredicates.isNull());
    }

    @Override
    public LazyDomElement equalsTo(String text) {
        return this.build(this.isOrNot("equal to"), text, StringPredicates.equalsTo(text));
    }

    @Override
    public LazyDomElement contains(String text) {
        return this.build(this.doesOrNot("contain"), text, StringPredicates.contains(text));
    }

    @Override
    public LazyDomElement contains(Pattern regex) {
        return this.build(this.doesOrNot("contain"), regex, StringPredicates.contains(regex));
    }

    @Override
    public LazyDomElement containsWord(String word) {
        return this.build(this.hasOrNot("word"), word, StringPredicates.containsWord(word));
    }

    @Override
    public LazyDomElement startsWith(String text) {
        return this.build(this.doesOrNot("start with"), text, StringPredicates.startsWith(text));
    }

    @Override
    public LazyDomElement endsWith(String text) {
        return this.build(this.doesOrNot("end with"), text, StringPredicates.endsWith(text));
    }

    @Override
    public LazyDomElement matches(Pattern regex) {
        return this.build(this.doesOrNot("match"), regex, StringPredicates.matches(regex));
    }

    @Override
    public LazyDomElement matches(Predicate<String> predicate) {
        return this.build(this.doesOrNot("match"), predicate, predicate);
    }

    private String doesOrNot(String verb) {
        return Text.doesOrNot(!this.ok, verb);
    }

    private String isOrNot(String state) {
        return Text.isOrNot(!this.ok, state);
    }

    private String hasOrNot(String what) {
        return Text.hasOrNot(!this.ok, what);
    }

    private LazyDomElement build(String word, Object details, Predicate<String> predicate) {
        String fullDescription = " with " + this.description + " that " + word;
        if (details != null) {
            fullDescription = fullDescription + " [" + details + "]";
        }
        UnaryOperator filter = stream -> stream.filter(element -> this.ok == predicate.test(this.toValue.apply((WebElement)element)));
        return this.domElement.with(new ElementFilter(fullDescription, filter));
    }
}

