/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.codestory.simplelenium.FilteredDomElement;
import net.codestory.simplelenium.Navigation;
import net.codestory.simplelenium.Should;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public interface DomElement
extends Navigation {
    public FilteredDomElement withText();

    public FilteredDomElement withId();

    public FilteredDomElement withName();

    public FilteredDomElement withTagName();

    public FilteredDomElement withClass();

    public FilteredDomElement withAttribute(String var1);

    public FilteredDomElement withCssValue(String var1);

    public FilteredDomElement with(String var1, Function<WebElement, String> var2);

    public DomElement first();

    public DomElement second();

    public DomElement third();

    public DomElement nth(int var1);

    public DomElement limit(int var1);

    public DomElement skip(int var1);

    public DomElement last();

    public DomElement filter(String var1, UnaryOperator<Stream<WebElement>> var2);

    default public DomElement withText(String text) {
        return this.withText().contains(text);
    }

    default public DomElement withId(String id) {
        return this.withId().equalsTo(id);
    }

    default public DomElement withName(String name) {
        return this.withName().equalsTo(name);
    }

    default public DomElement withClass(String cssClass) {
        return this.withClass().containsWord(cssClass);
    }

    default public DomElement withTagName(String name) {
        return this.withTagName().equalsTo(name);
    }

    public Should should();

    public DomElement fill(CharSequence var1);

    public DomElement pressReturn();

    public DomElement sendKeys(CharSequence ... var1);

    public DomElement clear();

    public DomElement submit();

    public DomElement click();

    public DomElement click(int var1, int var2);

    public DomElement doubleClick();

    public DomElement doubleClick(int var1, int var2);

    public DomElement clickAndHold();

    public DomElement contextClick();

    public DomElement release();

    public DomElement executeActions(String var1, BiConsumer<WebElement, Actions> var2);

    public DomElement select(String var1);

    public DomElement deselect();

    public DomElement deselectByValue(String var1);

    public DomElement deselectByVisibleText(String var1);

    public DomElement deselectByIndex(int var1);

    public DomElement selectByIndex(int var1);

    public DomElement selectByValue(String var1);

    public DomElement executeSelect(String var1, Consumer<Select> var2);

    public DomElement execute(Consumer<? super WebElement> var1);

    public DomElement retryFor(long var1, TimeUnit var3);
}

