/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.Should;
import net.codestory.simplelenium.driver.CurrentWebDriver;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.filters.ElementFilterBuilder;
import net.codestory.simplelenium.filters.LazyShould;
import net.codestory.simplelenium.filters.Retry;
import net.codestory.simplelenium.filters.StreamFilters;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public class LazyDomElement
implements DomElement {
    private final By selector;
    private final ElementFilter filter;
    private final Retry retry;

    public LazyDomElement(By selector) {
        this(selector, Retry._30_SECONDS);
    }

    public LazyDomElement(By selector, Retry retry) {
        this(selector, ElementFilter.any(), retry);
    }

    private LazyDomElement(By selector, ElementFilter filter, Retry retry) {
        this.selector = selector;
        this.filter = filter;
        this.retry = retry;
    }

    @Override
    public ElementFilterBuilder withText() {
        Function<WebElement, String> toValue = element -> element.getText();
        return this.with("text", (Function)toValue);
    }

    @Override
    public ElementFilterBuilder withId() {
        Function<WebElement, String> toValue = element -> element.getAttribute("id");
        return this.with("id", (Function)toValue);
    }

    @Override
    public ElementFilterBuilder withName() {
        Function<WebElement, String> toValue = element -> element.getAttribute("name");
        return this.with("id", (Function)toValue);
    }

    @Override
    public ElementFilterBuilder withTagName() {
        Function<WebElement, String> toValue = element -> element.getTagName();
        return this.with("tag name", (Function)toValue);
    }

    @Override
    public ElementFilterBuilder withClass() {
        Function<WebElement, String> toValue = element -> element.getAttribute("class");
        return this.with("class", (Function)toValue);
    }

    @Override
    public ElementFilterBuilder withAttribute(String name) {
        Function<WebElement, String> toValue = element -> element.getAttribute(name);
        return this.with("attribute[" + name + "]", (Function)toValue);
    }

    @Override
    public ElementFilterBuilder withCssValue(String name) {
        Function<WebElement, String> toValue = element -> element.getCssValue(name);
        return this.with("cssValue[" + name + "]", (Function)toValue);
    }

    @Override
    public ElementFilterBuilder with(String description, Function<WebElement, String> toValue) {
        return new ElementFilterBuilder(this, description, toValue, true);
    }

    @Override
    public LazyDomElement first() {
        return this.filter("first", (UnaryOperator)StreamFilters.first());
    }

    @Override
    public LazyDomElement second() {
        return this.filter("second", (UnaryOperator)StreamFilters.second());
    }

    @Override
    public LazyDomElement third() {
        return this.filter("third", (UnaryOperator)StreamFilters.third());
    }

    @Override
    public LazyDomElement nth(int index) {
        return this.filter("nth[" + index + "]", (UnaryOperator)StreamFilters.nth(index));
    }

    @Override
    public LazyDomElement limit(int max) {
        return this.filter("limit[" + max + "]", (UnaryOperator)StreamFilters.limit(max));
    }

    @Override
    public LazyDomElement skip(int count) {
        return this.filter("skip[" + count + "]", (UnaryOperator)StreamFilters.skip(count));
    }

    @Override
    public LazyDomElement last() {
        return this.filter("last", (UnaryOperator)StreamFilters.last());
    }

    @Override
    public LazyDomElement filter(String description, UnaryOperator<Stream<WebElement>> filter) {
        return this.with(new ElementFilter(", " + description, filter));
    }

    LazyDomElement with(ElementFilter filter) {
        return new LazyDomElement(this.selector, this.filter.and(filter), this.retry);
    }

    @Override
    public Should should() {
        return new LazyShould(this.selector, this.filter, Retry._5_SECONDS, false);
    }

    @Override
    public LazyDomElement fill(CharSequence text) {
        return this.execute("fill(" + text + ")", element -> element.sendKeys(new CharSequence[]{text}));
    }

    @Override
    public LazyDomElement pressReturn() {
        return this.execute("pressReturn()", element -> element.sendKeys(new CharSequence[]{Keys.RETURN}));
    }

    @Override
    public LazyDomElement sendKeys(CharSequence ... keysToSend) {
        return this.execute("sendKeys()", element -> element.sendKeys(keysToSend));
    }

    @Override
    public LazyDomElement clear() {
        return this.execute("clear()", element -> element.clear());
    }

    @Override
    public LazyDomElement submit() {
        return this.execute("submit", element -> element.submit());
    }

    @Override
    public LazyDomElement click() {
        return this.execute("click", element -> element.click());
    }

    @Override
    public LazyDomElement doubleClick() {
        return this.executeActions("doubleClick", (element, actions) -> actions.doubleClick(element));
    }

    @Override
    public LazyDomElement clickAndHold() {
        return this.executeActions("clickAndHold", (element, actions) -> actions.clickAndHold(element));
    }

    @Override
    public LazyDomElement contextClick() {
        return this.executeActions("contextClick", (element, actions) -> actions.contextClick(element));
    }

    @Override
    public LazyDomElement release() {
        return this.executeActions("release", (element, actions) -> actions.release(element));
    }

    @Override
    public LazyDomElement executeActions(String description, BiConsumer<WebElement, Actions> actionsOnElement) {
        return this.execute(description, element -> {
            Actions actions = new Actions(CurrentWebDriver.get());
            actionsOnElement.accept((WebElement)element, actions);
            actions.perform();
        });
    }

    @Override
    public LazyDomElement select(String text) {
        return this.executeSelect("select(" + text + ")", select -> select.selectByVisibleText(text));
    }

    @Override
    public LazyDomElement deselect() {
        return this.executeSelect("deselect()", select -> select.deselectAll());
    }

    @Override
    public LazyDomElement deselectByValue(String value) {
        return this.executeSelect("deselectByValue(" + value + ")", select -> select.deselectByValue(value));
    }

    @Override
    public LazyDomElement deselectByVisibleText(String text) {
        return this.executeSelect("deselectByVisibleText(" + text + ")", select -> select.deselectByVisibleText(text));
    }

    @Override
    public LazyDomElement deselectByIndex(int index) {
        return this.executeSelect("deselectByIndex(" + index + ")", select -> select.deselectByIndex(index));
    }

    @Override
    public LazyDomElement selectByIndex(int index) {
        return this.executeSelect("selectByIndex(" + index + ")", select -> select.selectByIndex(index));
    }

    @Override
    public LazyDomElement selectByValue(String value) {
        return this.executeSelect("selectByValue(" + value + ")", select -> select.selectByValue(value));
    }

    @Override
    public LazyDomElement executeSelect(String description, Consumer<Select> selectOnElement) {
        return this.execute(description, element -> selectOnElement.accept(new Select(element)));
    }

    @Override
    public LazyDomElement execute(Consumer<? super WebElement> action) {
        return this.execute("execute(" + action + ")", action);
    }

    @Override
    public LazyDomElement retryFor(long duration, TimeUnit timeUnit) {
        return new LazyDomElement(this.selector, this.filter.and(this.filter), new Retry(duration, timeUnit));
    }

    private LazyDomElement execute(String message, Consumer<? super WebElement> action) {
        System.out.println(" - " + Text.toString(this.selector) + this.filter.getDescription() + "." + message);
        try {
            this.retry.execute(() -> this.findOne(), action);
        }
        catch (NoSuchElementException e) {
            throw new AssertionError((Object)("Element not found: " + Text.toString(this.selector)));
        }
        return this;
    }

    private WebElement findOne() {
        Stream webElements = CurrentWebDriver.get().findElements(this.selector).stream();
        Stream filtered = (Stream)this.filter.getFilter().apply(webElements);
        return filtered.findFirst().orElse(null);
    }
}

