/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

class Retry {
    public static final Retry _5_SECONDS = new Retry(5L, TimeUnit.SECONDS);
    public static final Retry _30_SECONDS = new Retry(30L, TimeUnit.SECONDS);
    private final long timeoutInMs;

    public Retry(long duration, TimeUnit timeUnit) {
        this.timeoutInMs = timeUnit.toMillis(duration);
    }

    <T> void execute(Supplier<T> target, Consumer<T> action) {
        WebDriverException lastError = null;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeoutInMs) {
            try {
                T targetElement = target.get();
                if (targetElement == null) continue;
                action.accept(targetElement);
                return;
            }
            catch (WebDriverException e) {
                lastError = e;
            }
        }
        throw lastError;
    }

    <T> boolean verify(Supplier<T> targetSupplier, Predicate<T> predicate) throws NoSuchElementException {
        Error error = Error.KO;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeoutInMs) {
            try {
                if (predicate.test(targetSupplier.get())) {
                    return true;
                }
                error = Error.KO;
            }
            catch (InvalidElementStateException e) {
                error = Error.KO;
            }
            catch (NotFoundException e) {
                error = Error.NOT_FOUND;
            }
            catch (StaleElementReferenceException e) {}
        }
        if (error == Error.NOT_FOUND) {
            throw new NoSuchElementException("Not found");
        }
        return false;
    }

    static enum Error {
        NOT_FOUND,
        KO;

    }
}

