/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.Should;
import net.codestory.simplelenium.driver.CurrentWebDriver;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.filters.ElementFilterBuilder;
import net.codestory.simplelenium.filters.LazyShould;
import net.codestory.simplelenium.filters.Retry;
import net.codestory.simplelenium.filters.StreamFilters;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public class LazyDomElement
implements DomElement {
    private final By selector;
    private final ElementFilter filter;
    private final Retry retry;

    public LazyDomElement(By selector) {
        this(selector, Retry._30_SECONDS);
    }

    public LazyDomElement(By selector, Retry retry) {
        this(selector, ElementFilter.any(), retry);
    }

    private LazyDomElement(By selector, ElementFilter filter, Retry retry) {
        this.selector = selector;
        this.filter = filter;
        this.retry = retry;
    }

    @Override
    public ElementFilterBuilder withText() {
        return this.narrow("text", element -> element.getText());
    }

    @Override
    public ElementFilterBuilder withId() {
        return this.narrow("id", element -> element.getAttribute("id"));
    }

    @Override
    public ElementFilterBuilder withName() {
        return this.narrow("id", element -> element.getAttribute("name"));
    }

    @Override
    public ElementFilterBuilder withTagName() {
        return this.narrow("tag name", element -> element.getTagName());
    }

    @Override
    public ElementFilterBuilder withClass() {
        return this.narrow("class", element -> element.getAttribute("class"));
    }

    @Override
    public ElementFilterBuilder withAttribute(String name) {
        return this.narrow("attribute[" + name + "]", element -> element.getAttribute(name));
    }

    @Override
    public ElementFilterBuilder withCssValue(String name) {
        return this.narrow("cssValue[" + name + "]", element -> element.getCssValue(name));
    }

    private ElementFilterBuilder narrow(String description, Function<WebElement, String> toValue) {
        return new ElementFilterBuilder(this, description, toValue, true);
    }

    @Override
    public LazyDomElement first() {
        return this.filter("first", StreamFilters.first());
    }

    @Override
    public LazyDomElement second() {
        return this.filter("second", StreamFilters.second());
    }

    @Override
    public LazyDomElement third() {
        return this.filter("third", StreamFilters.third());
    }

    @Override
    public LazyDomElement nth(int index) {
        return this.filter("nth[" + index + "]", StreamFilters.nth(index));
    }

    @Override
    public LazyDomElement limit(int max) {
        return this.filter("limit[" + max + "]", StreamFilters.limit(max));
    }

    @Override
    public LazyDomElement skip(int count) {
        return this.filter("skip[" + count + "]", StreamFilters.skip(count));
    }

    @Override
    public LazyDomElement last() {
        return this.filter("last", StreamFilters.last());
    }

    private LazyDomElement filter(String description, UnaryOperator<Stream<WebElement>> filter) {
        return this.with(new ElementFilter(", " + description, filter));
    }

    LazyDomElement with(ElementFilter filter) {
        return new LazyDomElement(this.selector, this.filter.and(filter), this.retry);
    }

    @Override
    public Should should() {
        return new LazyShould(this.selector, this.filter, Retry._5_SECONDS, false);
    }

    @Override
    public void fill(CharSequence text) {
        this.execute("fill(" + text + ")", element -> element.sendKeys(new CharSequence[]{text}));
    }

    @Override
    public void pressReturn() {
        this.execute("pressReturn()", element -> element.sendKeys(new CharSequence[]{Keys.RETURN}));
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        this.execute("sendKeys()", element -> element.sendKeys(keysToSend));
    }

    @Override
    public void clear() {
        this.execute("clear()", element -> element.clear());
    }

    @Override
    public void submit() {
        this.execute("submit", element -> element.submit());
    }

    @Override
    public void click() {
        this.execute("click", element -> element.click());
    }

    @Override
    public void doubleClick() {
        this.executeActions("doubleClick", (element, actions) -> actions.doubleClick(element));
    }

    @Override
    public void clickAndHold() {
        this.executeActions("clickAndHold", (element, actions) -> actions.clickAndHold(element));
    }

    @Override
    public void contextClick() {
        this.executeActions("contextClick", (element, actions) -> actions.contextClick(element));
    }

    @Override
    public void release() {
        this.executeActions("release", (element, actions) -> actions.release(element));
    }

    @Override
    public void executeActions(String description, BiConsumer<WebElement, Actions> actionsOnElement) {
        this.execute(description, element -> {
            Actions actions = new Actions(CurrentWebDriver.get());
            actionsOnElement.accept((WebElement)element, actions);
            actions.perform();
        });
    }

    @Override
    public void select(String text) {
        this.executeSelect("select(" + text + ")", select -> select.selectByVisibleText(text));
    }

    @Override
    public void deselect() {
        this.executeSelect("deselect()", select -> select.deselectAll());
    }

    @Override
    public void deselectByValue(String value) {
        this.executeSelect("deselectByValue(" + value + ")", select -> select.deselectByValue(value));
    }

    @Override
    public void deselectByVisibleText(String text) {
        this.executeSelect("deselectByVisibleText(" + text + ")", select -> select.deselectByVisibleText(text));
    }

    @Override
    public void deselectByIndex(int index) {
        this.executeSelect("deselectByIndex(" + index + ")", select -> select.deselectByIndex(index));
    }

    @Override
    public void selectByIndex(int index) {
        this.executeSelect("selectByIndex(" + index + ")", select -> select.selectByIndex(index));
    }

    @Override
    public void selectByValue(String value) {
        this.executeSelect("selectByValue(" + value + ")", select -> select.selectByValue(value));
    }

    @Override
    public void executeSelect(String description, Consumer<Select> selectOnElement) {
        this.execute(description, element -> {
            Select select = new Select(element);
            selectOnElement.accept(select);
        });
    }

    @Override
    public void execute(Consumer<? super WebElement> action) {
        this.execute("execute(" + action + ")", action);
    }

    @Override
    public LazyDomElement retryFor(long duration, TimeUnit timeUnit) {
        return new LazyDomElement(this.selector, this.filter.and(this.filter), new Retry(duration, timeUnit));
    }

    private void execute(String message, Consumer<? super WebElement> action) {
        System.out.println(" - " + Text.toString(this.selector) + this.filter.getDescription() + "." + message);
        this.retry.execute(() -> this.findOne(), action);
    }

    private WebElement findOne() {
        Stream webElements = CurrentWebDriver.get().findElements(this.selector).stream();
        Stream filtered = (Stream)this.filter.getFilter().apply(webElements);
        return filtered.findFirst().orElse(null);
    }
}

