/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.codestory.simplelenium.FilteredDomElement;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.filters.LazyDomElement;
import net.codestory.simplelenium.filters.StringPredicates;
import org.openqa.selenium.WebElement;

class ElementFilterBuilder
implements FilteredDomElement {
    private final LazyDomElement domElement;
    private final String description;
    private final Function<WebElement, String> toValue;
    private final boolean ok;

    ElementFilterBuilder(LazyDomElement domElement, String description, Function<WebElement, String> toValue, boolean ok) {
        this.domElement = domElement;
        this.description = description;
        this.toValue = toValue;
        this.ok = ok;
    }

    @Override
    public ElementFilterBuilder not() {
        return new ElementFilterBuilder(this.domElement, this.description, this.toValue, !this.ok);
    }

    @Override
    public LazyDomElement equalsTo(String text) {
        return this.build("is equal to", text, StringPredicates.equalsTo(text));
    }

    @Override
    public LazyDomElement contains(String text) {
        return this.build("contains", text, StringPredicates.contains(text));
    }

    @Override
    public LazyDomElement contains(Pattern regex) {
        return this.build("contains", regex, StringPredicates.contains(regex));
    }

    @Override
    public LazyDomElement containsWord(String word) {
        return this.build("has word", word, StringPredicates.containsWord(word));
    }

    @Override
    public LazyDomElement startsWith(String text) {
        return this.build("starts with", text, StringPredicates.startsWith(text));
    }

    @Override
    public LazyDomElement endsWith(String text) {
        return this.build("ends with", text, StringPredicates.endsWith(text));
    }

    @Override
    public LazyDomElement matches(Pattern regex) {
        return this.build("matches", regex, StringPredicates.matches(regex));
    }

    @Override
    public LazyDomElement matches(Predicate<String> predicate) {
        return this.build("matches", predicate, predicate);
    }

    private LazyDomElement build(String word, Object details, Predicate<String> predicate) {
        String fullDescription = " with " + this.description + " that " + word + " [" + details + "]";
        UnaryOperator filter = stream -> stream.filter(element -> this.ok == predicate.test(this.toValue.apply((WebElement)element)));
        return this.domElement.with(new ElementFilter(fullDescription, filter));
    }
}

