/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.function.Function;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static void injectNullFieldsOfType(Class<?> type, Object target, Function<Field, Object> factory) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                if (field.get(target) != null) continue;
                field.set(target, factory.apply(field));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Unable to set field [%s] on instance of type [%s]", field.getName(), target.getClass().getName()));
            }
        }
    }

    public static void injectNullFieldsWithConstructorParameterOfType(Class<?> type, Object target, Function<Field, Object> factory) {
        for (Field field : target.getClass().getDeclaredFields()) {
            try {
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                if (field.get(target) != null) continue;
                Constructor<?> constructor = field.getType().getDeclaredConstructor(type);
                constructor.setAccessible(true);
                field.set(target, constructor.newInstance(factory.apply(field)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("Unable to set field [%s] on instance of type [%s]", field.getName(), target.getClass().getName()));
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    public static <T> T newInstance(Class<T> type) {
        T instance;
        Constructor<T> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Couldn't create Page Object. Missing 0 arg constructor on type " + type, e);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create instance of type " + type, e);
        }
        return instance;
    }
}

