/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.function.Predicate;
import java.util.regex.Pattern;

class StringPredicates {
    private StringPredicates() {
    }

    public static Predicate<String> equalsTo(String text) {
        return value -> value.equals(text);
    }

    public static Predicate<String> contains(String text) {
        return value -> value.contains(text);
    }

    public static Predicate<String> contains(Pattern regex) {
        return value -> regex.matcher((CharSequence)value).find();
    }

    public static Predicate<String> containsWord(String word) {
        Pattern pattern = Pattern.compile("\\b(" + word + ")\\b");
        return value -> pattern.matcher((CharSequence)value).find();
    }

    public static Predicate<String> startsWith(String text) {
        return value -> value.startsWith(text);
    }

    public static Predicate<String> endsWith(String text) {
        return value -> value.endsWith(text);
    }

    public static Predicate<String> matches(Pattern regex) {
        return value -> regex.matcher((CharSequence)value).matches();
    }
}

