/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.codestory.simplelenium.FilteredDomElement;
import net.codestory.simplelenium.Should;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public interface DomElement {
    public FilteredDomElement withText();

    public FilteredDomElement withId();

    public FilteredDomElement withName();

    public FilteredDomElement withTagName();

    public FilteredDomElement withClass();

    public FilteredDomElement withAttribute(String var1);

    public FilteredDomElement withCssValue(String var1);

    public DomElement first();

    public DomElement second();

    public DomElement third();

    public DomElement nth(int var1);

    public DomElement limit(int var1);

    public DomElement skip(int var1);

    public DomElement last();

    default public DomElement withText(String text) {
        return this.withText().contains(text);
    }

    default public DomElement withId(String id) {
        return this.withId().equalsTo(id);
    }

    default public DomElement withName(String name) {
        return this.withName().equalsTo(name);
    }

    default public DomElement withClass(String cssClass) {
        return this.withClass().containsWord(cssClass);
    }

    default public DomElement withTagName(String name) {
        return this.withTagName().equalsTo(name);
    }

    public Should should();

    public void fill(CharSequence var1);

    public void pressReturn();

    public void sendKeys(CharSequence ... var1);

    public void clear();

    public void submit();

    public void click();

    public void doubleClick();

    public void clickAndHold();

    public void contextClick();

    public void release();

    public void executeActions(String var1, BiConsumer<WebElement, Actions> var2);

    public void select(String var1);

    public void deselect();

    public void deselectByValue(String var1);

    public void deselectByVisibleText(String var1);

    public void deselectByIndex(int var1);

    public void selectByIndex(int var1);

    public void selectByValue(String var1);

    public void executeSelect(String var1, Consumer<Select> var2);

    public void execute(Consumer<? super WebElement> var1);

    public DomElement retryFor(long var1, TimeUnit var3);
}

