/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.codestory.simplelenium.Retry;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Should {
    private final WebDriver driver;
    private final String selector;
    private final Retry retry;
    private final boolean not;

    Should(WebDriver driver, String selector, long duration, TimeUnit timeUnit) {
        this(driver, selector, new Retry(duration, timeUnit), false);
    }

    private Should(WebDriver driver, String selector, Retry retry, boolean not) {
        this.driver = driver;
        this.selector = selector;
        this.retry = retry;
        this.not = not;
    }

    public Should not() {
        return new Should(this.driver, this.selector, this.retry, !this.not);
    }

    public void contain(String ... texts) {
        this.verify("contains(" + String.join((CharSequence)";", texts) + ")", this::find, element -> Stream.of(texts).allMatch(expected -> element.getText().contains((CharSequence)expected)));
    }

    public void notContain(String text) {
        this.verify("does not contain (" + text + ")", this::find, element -> !element.getText().contains(text));
    }

    public void beEnabled() {
        this.verify("is enabled", this::find, element -> element.isEnabled());
    }

    public void beDisabled() {
        this.verify("is disabled", this::find, element -> !element.isEnabled());
    }

    public void beDisplayed() {
        this.verify("is displayed", this::find, element -> element.isDisplayed());
    }

    public void beHidden() {
        this.verify("is hidden", this::find, element -> !element.isDisplayed());
    }

    public void beSelected() {
        this.verify("is selected", this::find, element -> element.isSelected());
    }

    public void haveNoMoreItemsThan(int maxCount) {
        this.verify("has at most " + maxCount + " items", this::findMultiple, elements -> elements.size() <= maxCount);
    }

    public void haveSize(int size) {
        this.verify("has size " + size, this::findMultiple, elements -> elements.size() == size);
    }

    public void beEmpty() {
        this.verify("is empty", this::findMultiple, elements -> elements.isEmpty());
    }

    private <T> void verify(String message, Supplier<T> target, Predicate<T> predicate) {
        String verification = "verify that " + this.selector + " " + message;
        System.out.println("   -> " + verification);
        if (this.retry.verify(target, predicate) == this.not) {
            throw new AssertionError((Object)("Failed to " + verification));
        }
    }

    private WebElement find() {
        return this.driver.findElement(By.cssSelector((String)this.selector));
    }

    private List<WebElement> findMultiple() {
        return this.driver.findElements(By.cssSelector((String)this.selector));
    }
}

