/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.Iterator;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.openqa.selenium.WebElement;

public class StreamFilters {
    private StreamFilters() {
    }

    public static UnaryOperator<Stream<WebElement>> first() {
        return stream -> stream.limit(1L);
    }

    public static UnaryOperator<Stream<WebElement>> second() {
        return stream -> stream.skip(1L).limit(1L);
    }

    public static UnaryOperator<Stream<WebElement>> third() {
        return stream -> stream.skip(2L).limit(1L);
    }

    public static UnaryOperator<Stream<WebElement>> nth(int index) {
        return stream -> stream.skip(index - 1).limit(1L);
    }

    public static UnaryOperator<Stream<WebElement>> limit(int max) {
        return stream -> stream.limit(max);
    }

    public static UnaryOperator<Stream<WebElement>> skip(int count) {
        return stream -> stream.skip(count);
    }

    public static UnaryOperator<Stream<WebElement>> last() {
        return stream -> {
            Iterator iterator = stream.iterator();
            WebElement last = null;
            while (iterator.hasNext()) {
                last = (WebElement)iterator.next();
            }
            return last == null ? Stream.empty() : Stream.of(last);
        };
    }
}

