/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.filters.StringPredicates;
import org.openqa.selenium.WebElement;

public class ElementFilterBuilder {
    private final DomElement domElement;
    private final String description;
    private final Function<WebElement, String> toValue;
    private final boolean ok;

    public ElementFilterBuilder(DomElement domElement, String description, Function<WebElement, String> toValue, boolean ok) {
        this.domElement = domElement;
        this.description = description;
        this.toValue = toValue;
        this.ok = ok;
    }

    public ElementFilterBuilder not() {
        return new ElementFilterBuilder(this.domElement, this.description, this.toValue, !this.ok);
    }

    public DomElement equalsTo(String text) {
        return this.build("is equal to", text, StringPredicates.equalsTo(text));
    }

    public DomElement contains(String text) {
        return this.build("contains", text, StringPredicates.contains(text));
    }

    public DomElement contains(Pattern regex) {
        return this.build("contains", regex, StringPredicates.contains(regex));
    }

    public DomElement containsWord(String word) {
        return this.build("has word", word, StringPredicates.containsWord(word));
    }

    public DomElement startsWith(String text) {
        return this.build("starts with", text, StringPredicates.startsWith(text));
    }

    public DomElement endsWith(String text) {
        return this.build("ends with", text, StringPredicates.endsWith(text));
    }

    public DomElement matches(Pattern regex) {
        return this.build("matches", regex, StringPredicates.matches(regex));
    }

    public DomElement matches(Predicate<String> predicate) {
        return this.build("matches", predicate, predicate);
    }

    private DomElement build(String word, Object details, Predicate<String> predicate) {
        String fullDescription = " with " + this.description + " that " + word + " [" + details + "]";
        UnaryOperator filter = stream -> stream.filter(element -> this.ok == predicate.test(this.toValue.apply((WebElement)element)));
        return this.domElement.with(new ElementFilter(fullDescription, filter));
    }
}

