/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.codestory.simplelenium.Navigation;
import net.codestory.simplelenium.SectionObject;
import net.codestory.simplelenium.driver.CurrentWebDriver;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public abstract class SeleniumTest
implements SectionObject {
    private final WebDriver driver = this.createWebDriver();
    public TestName testName = new TestName(){

        protected void starting(Description d) {
            super.starting(d);
            System.out.println("-----------------------------------------");
            System.out.println(((Object)((Object)this)).getClass().getSimpleName() + "." + this.getMethodName());
            System.out.println("-----------------------------------------");
        }
    };
    public TestWatcher injectMissingPageObjects = new TestWatcher(){

        protected void starting(Description desc) {
            SectionObject.injectMissingPageObjects(SeleniumTest.this);
            SectionObject.injectMissingElements(SeleniumTest.this);
        }
    };
    public TestWatcher takeSnapshot = new TestWatcher(){

        protected void failed(Throwable e, Description desc) {
            SeleniumTest.this.takeSnapshot("");
        }
    };
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testName).around((TestRule)this.injectMissingPageObjects).around((TestRule)this.takeSnapshot);

    public SeleniumTest takeSnapshot(String suffix) {
        try {
            byte[] snapshotData = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
            File snapshot = this.snapshotPath(suffix);
            snapshot.getParentFile().mkdirs();
            Files.write((byte[])snapshotData, (File)snapshot);
            System.err.println("   !! A snapshot was taken here [" + snapshot.getAbsoluteFile() + "] to help you debug");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to take snapshot", ioe);
        }
        return this;
    }

    protected File snapshotPath(String suffix) {
        return new File("snapshots", this.getClass().getSimpleName() + "_" + this.testName.getMethodName() + suffix + ".png");
    }

    protected WebDriver createWebDriver() {
        WebDriver driver = CurrentWebDriver.get();
        driver.manage().window().setSize(new Dimension(2048, 768));
        return driver;
    }

    protected String getDefaultBaseUrl() {
        return "";
    }

    @Override
    public SeleniumTest goTo(String url) {
        Navigation.setBaseUrl(this.getDefaultBaseUrl());
        SectionObject.super.goTo(url);
        return this;
    }
}

