/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.codestory.simplelenium.Retry;
import net.codestory.simplelenium.Should;
import net.codestory.simplelenium.driver.CurrentWebDriver;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.filters.ElementFilterBuilder;
import net.codestory.simplelenium.filters.StreamFilters;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public class DomElement {
    private final By selector;
    private final ElementFilter filter;
    private final Retry retry;

    public DomElement(By selector) {
        this(selector, ElementFilter.any(), Retry._30_SECONDS);
    }

    private DomElement(By selector, ElementFilter filter, Retry retry) {
        this.selector = selector;
        this.filter = filter;
        this.retry = retry;
    }

    public DomElement with(ElementFilter filter) {
        return new DomElement(this.selector, this.filter.and(filter), this.retry);
    }

    public ElementFilterBuilder withText() {
        return this.narrow("text", element -> element.getText());
    }

    public ElementFilterBuilder withId() {
        return this.narrow("id", element -> element.getAttribute("id"));
    }

    public ElementFilterBuilder withName() {
        return this.narrow("id", element -> element.getAttribute("name"));
    }

    public ElementFilterBuilder withTagName() {
        return this.narrow("tag name", element -> element.getTagName());
    }

    public ElementFilterBuilder withClass() {
        return this.narrow("class", element -> element.getAttribute("class"));
    }

    public ElementFilterBuilder withAttribute(String name) {
        return this.narrow("attribute[" + name + "]", element -> element.getAttribute(name));
    }

    public ElementFilterBuilder withCssValue(String name) {
        return this.narrow("cssValue[" + name + "]", element -> element.getCssValue(name));
    }

    private ElementFilterBuilder narrow(String description, Function<WebElement, String> toValue) {
        return new ElementFilterBuilder(this, description, toValue, true);
    }

    public DomElement first() {
        return this.filter("first", StreamFilters.first());
    }

    public DomElement second() {
        return this.filter("second", StreamFilters.second());
    }

    public DomElement third() {
        return this.filter("third", StreamFilters.third());
    }

    public DomElement nth(int index) {
        return this.filter("nth[" + index + "]", StreamFilters.nth(index));
    }

    public DomElement limit(int max) {
        return this.filter("limit[" + max + "]", StreamFilters.limit(max));
    }

    public DomElement skip(int count) {
        return this.filter("skip[" + count + "]", StreamFilters.skip(count));
    }

    public DomElement last() {
        return this.filter("last", StreamFilters.last());
    }

    private DomElement filter(String description, UnaryOperator<Stream<WebElement>> filter) {
        return this.with(new ElementFilter(", " + description, filter));
    }

    public DomElement withText(String text) {
        return this.withText().contains(text);
    }

    public DomElement withId(String id) {
        return this.withId().equalsTo(id);
    }

    public DomElement withName(String name) {
        return this.withName().equalsTo(name);
    }

    public DomElement withClass(String cssClass) {
        return this.withClass().containsWord(cssClass);
    }

    public DomElement withTagName(String name) {
        return this.withTagName().equalsTo(name);
    }

    public Should should() {
        return new Should(this.selector, this.filter, Retry._5_SECONDS, false);
    }

    public void fill(CharSequence text) {
        this.execute("fill(" + text + ")", element -> element.sendKeys(new CharSequence[]{text}));
    }

    public void pressReturn() {
        this.execute("pressReturn()", element -> element.sendKeys(new CharSequence[]{Keys.RETURN}));
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.execute("sendKeys()", element -> element.sendKeys(keysToSend));
    }

    public void clear() {
        this.execute("clear()", element -> element.clear());
    }

    public void submit() {
        this.execute("submit", element -> element.submit());
    }

    public void click() {
        this.execute("click", element -> element.click());
    }

    public void doubleClick() {
        this.executeActions("doubleClick", (element, actions) -> actions.doubleClick(element));
    }

    public void clickAndHold() {
        this.executeActions("clickAndHold", (element, actions) -> actions.clickAndHold(element));
    }

    public void contextClick() {
        this.executeActions("contextClick", (element, actions) -> actions.contextClick(element));
    }

    public void release() {
        this.executeActions("release", (element, actions) -> actions.release(element));
    }

    public void executeActions(String description, BiConsumer<WebElement, Actions> actionsOnElement) {
        this.execute(description, element -> {
            Actions actions = new Actions(CurrentWebDriver.get());
            actionsOnElement.accept((WebElement)element, actions);
            actions.perform();
        });
    }

    public void select(String text) {
        this.executeSelect("select(" + text + ")", select -> select.selectByVisibleText(text));
    }

    public void deselect() {
        this.executeSelect("deselect()", select -> select.deselectAll());
    }

    public void deselectByValue(String value) {
        this.executeSelect("deselectByValue(" + value + ")", select -> select.deselectByValue(value));
    }

    public void deselectByVisibleText(String text) {
        this.executeSelect("deselectByVisibleText(" + text + ")", select -> select.deselectByVisibleText(text));
    }

    public void deselectByIndex(int index) {
        this.executeSelect("deselectByIndex(" + index + ")", select -> select.deselectByIndex(index));
    }

    public void selectByIndex(int index) {
        this.executeSelect("selectByIndex(" + index + ")", select -> select.selectByIndex(index));
    }

    public void selectByValue(String value) {
        this.executeSelect("selectByValue(" + value + ")", select -> select.selectByValue(value));
    }

    public void executeSelect(String description, Consumer<Select> selectOnElement) {
        this.execute(description, element -> {
            Select select = new Select(element);
            selectOnElement.accept(select);
        });
    }

    public void execute(Consumer<? super WebElement> action) {
        this.execute("execute(" + action + ")", action);
    }

    public DomElement retryFor(long duration, TimeUnit timeUnit) {
        return new DomElement(this.selector, this.filter.and(this.filter), new Retry(duration, timeUnit));
    }

    private void execute(String message, Consumer<? super WebElement> action) {
        System.out.println(" - " + Text.toString(this.selector) + this.filter.getDescription() + "." + message);
        this.retry.execute(() -> this.findOne(), action);
    }

    private WebElement findOne() {
        Stream webElements = CurrentWebDriver.get().findElements(this.selector).stream();
        Stream filtered = (Stream)this.filter.getFilter().apply(webElements);
        return filtered.findFirst().orElse(null);
    }
}

