/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static void forEachFieldOfType(Class<?> type, Object target, Consumer<Field> action) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            action.accept(field);
        }
    }

    public static void setIfNull(Field field, Object target, Supplier<Object> valueSupplier) {
        if (Modifier.isFinal(field.getModifiers())) {
            return;
        }
        try {
            field.setAccessible(true);
            if (field.get(target) == null) {
                field.set(target, valueSupplier.get());
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Unable to set field [%s] on instance of type [%s]", field.getName(), target.getClass().getName()));
        }
    }

    public static <T> T newInstance(Class<T> type) {
        T instance;
        Constructor<T> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Couldn't create Page Object. Missing 0 arg constructor on type " + type, e);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create instance of type " + type, e);
        }
        return instance;
    }
}

