/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.misc;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.List;

public class LockFile {
    private static final List<LockFile> LOCKS_TAKEN = Lists.newCopyOnWriteArrayList();
    private final File lockFile;
    private FileLock lock;

    public LockFile(File lockFile) {
        this.lockFile = lockFile;
    }

    public void waitLock() {
        while (true) {
            try {
                this.lock = new FileOutputStream(this.lockFile).getChannel().tryLock();
                if (this.lock != null) {
                    LOCKS_TAKEN.add(this);
                    return;
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
            LockFile.waitBeforeRetry();
        }
    }

    public void release() {
        if (this.lock == null) {
            throw new IllegalStateException("Lock before unlock");
        }
        try {
            LOCKS_TAKEN.remove(this);
            this.lock.release();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to release lock");
        }
    }

    private static void waitBeforeRetry() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

