/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.filters.ElementFilter;
import org.openqa.selenium.WebElement;

public class ElementFilterBuilder {
    private final DomElement domElement;
    private final String description;
    private final Function<WebElement, String> toValue;
    private final Predicate<Boolean> ok;

    public ElementFilterBuilder(DomElement domElement, String description, Function<WebElement, String> toValue, Predicate<Boolean> ok) {
        this.domElement = domElement;
        this.description = description;
        this.toValue = toValue;
        this.ok = ok;
    }

    public ElementFilterBuilder not() {
        return new ElementFilterBuilder(this.domElement, this.description, this.toValue, this.ok.negate());
    }

    public DomElement equalsTo(String text) {
        return this.build("=[" + text + "]", value -> value.equals(text));
    }

    public DomElement contains(String text) {
        return this.build(" contains[" + text + "]", value -> value.contains(text));
    }

    public DomElement contains(Pattern regex) {
        return this.build(" contains[" + regex + "]", value -> regex.matcher((CharSequence)value).find());
    }

    public DomElement containsWord(String word) {
        Pattern pattern = ElementFilterBuilder.patternForWord(word);
        return this.build(" has word[" + word + "]", value -> pattern.matcher((CharSequence)value).find());
    }

    public DomElement startsWith(String text) {
        return this.build(" startsWith[" + text + "]", value -> value.startsWith(text));
    }

    public DomElement endsWith(String text) {
        return this.build(" endsWith[" + text + "]", value -> value.endsWith(text));
    }

    public DomElement matches(Pattern regex) {
        return this.build(" matches[" + regex + "]", value -> regex.matcher((CharSequence)value).matches());
    }

    public DomElement matches(Predicate<String> predicate) {
        return this.build(" matches[" + predicate + "]", predicate);
    }

    static Pattern patternForWord(String word) {
        return Pattern.compile("\\b(" + word + ")\\b");
    }

    private DomElement build(String details, Predicate<String> predicate) {
        UnaryOperator filter = stream -> stream.filter(element -> this.ok.test(predicate.test(this.toValue.apply((WebElement)element))));
        return this.domElement.with(new ElementFilter(" with " + this.description + details, filter));
    }
}

