/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codestory.simplelenium.Navigation;
import net.codestory.simplelenium.Retry;
import net.codestory.simplelenium.driver.CurrentWebDriver;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class Should
implements Navigation {
    private final By selector;
    private final ElementFilter filter;
    private final Retry retry;
    private final boolean not;

    Should(By selector, ElementFilter filter, Retry retry, boolean not) {
        this.selector = selector;
        this.filter = filter;
        this.retry = retry;
        this.not = not;
    }

    public Should within(long duration, TimeUnit timeUnit) {
        return new Should(this.selector, this.filter, new Retry(duration, timeUnit), this.not);
    }

    public Should not() {
        return new Should(this.selector, this.filter, this.retry, !this.not);
    }

    public Should and() {
        return this;
    }

    public Should should() {
        return this;
    }

    public Should contain(String ... texts) {
        return this.verify(this.doesOrNot("contain") + " (" + String.join((CharSequence)";", texts) + ")", elements -> Stream.of(texts).allMatch(expected -> elements.stream().anyMatch(element -> element.getText().contains((CharSequence)expected))), elements -> "It contains " + Should.statuses(elements, element -> element.getText()));
    }

    public Should match(Pattern regexp) {
        return this.verify(this.doesOrNot("match") + " (" + regexp.pattern() + ")", elements -> elements.stream().anyMatch(element -> regexp.matcher(element.getText()).matches()), elements -> "It contains " + Should.statuses(elements, element -> element.getText()));
    }

    public Should beEnabled() {
        return this.verify(this.isOrNot("enabled"), elements -> elements.stream().allMatch(element -> element.isEnabled()), elements -> "It is " + Should.statuses(elements, element -> Should.enabledStatus(element)));
    }

    public Should beDisplayed() {
        return this.verify(this.isOrNot("displayed"), elements -> elements.stream().allMatch(element -> element.isDisplayed()), elements -> "It is " + Should.statuses(elements, element -> Should.displayedStatus(element)));
    }

    public Should beSelected() {
        return this.verify(this.isOrNot("selected"), elements -> elements.stream().allMatch(element -> Should.isSelected(element)), elements -> "It is " + Should.statuses(elements, element -> Should.selectedStatus(element)));
    }

    public Should haveLessItemsThan(int maxCount) {
        return this.verify(this.doesOrNot("contain") + " less than " + Text.plural(maxCount, "element"), elements -> elements.size() < maxCount, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should haveSize(int size) {
        return this.verify(this.doesOrNot("contain") + " " + Text.plural(size, "element"), elements -> elements.size() == size, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should haveMoreItemsThan(int minCount) {
        return this.verify(this.doesOrNot("contain") + " more than " + Text.plural(minCount, "element"), elements -> elements.size() > minCount, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should beEmpty() {
        return this.verify(this.isOrNot("empty"), elements -> elements.isEmpty(), elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should exist() {
        return this.verify(this.doesOrNot("exist"), elements -> !elements.isEmpty(), elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should haveDimension(int width, int height) {
        return this.verify(this.hasOrNot("dimension"), elements -> elements.stream().allMatch(element -> Should.hasDimension(element, width, height)), elements -> "It measures " + Should.statuses(elements, element -> Should.dimension(element)));
    }

    public Should beAtLocation(int x, int y) {
        return this.verify(this.isOrNot("at location"), elements -> elements.stream().allMatch(element -> Should.hasLocation(element, x, y)), elements -> "It is at location " + Should.statuses(elements, element -> Should.location(element)));
    }

    private Should verify(String message, Predicate<List<WebElement>> predicate, Function<List<WebElement>, String> toErrorMessage) {
        String verification = "verify that " + Text.toString(this.selector) + this.filter.getDescription() + " " + message;
        System.out.println("   -> " + verification);
        try {
            if (!this.retry.verify(() -> this.findElements(), this.not ? predicate.negate() : predicate)) {
                throw new AssertionError((Object)("Failed to " + verification + ". " + toErrorMessage.apply(this.findElements())));
            }
        }
        catch (NoSuchElementException e) {
            throw new AssertionError((Object)("Element not found. Failed to " + verification));
        }
        return this.not ? this.not() : this;
    }

    private List<WebElement> findElements() {
        Stream webElements = CurrentWebDriver.get().findElements(this.selector).stream();
        Stream filtered = (Stream)this.filter.getFilter().apply(webElements);
        return filtered.collect(Collectors.toList());
    }

    private String doesOrNot(String verb) {
        return Text.doesOrNot(this.not, verb);
    }

    private String isOrNot(String state) {
        return Text.isOrNot(this.not, state);
    }

    private String hasOrNot(String what) {
        return Text.hasOrNot(this.not, what);
    }

    private static boolean hasDimension(WebElement element, int width, int height) {
        Dimension dimension = element.getSize();
        return dimension.getWidth() == width && dimension.getHeight() == height;
    }

    private static boolean hasLocation(WebElement element, int x, int y) {
        Point location = element.getLocation();
        return location.getX() == x && location.getY() == y;
    }

    private static boolean isSelected(WebElement element) {
        return Should.isSelectable(element) && element.isSelected();
    }

    private static String statuses(List<WebElement> elements, Function<WebElement, String> toStatus) {
        return elements.stream().map(toStatus).collect(Collectors.joining(";", "(", ")"));
    }

    private static String enabledStatus(WebElement element) {
        return element.isEnabled() ? "enabled" : "not enabled";
    }

    private static String displayedStatus(WebElement element) {
        return element.isDisplayed() ? "displayed" : "not displayed";
    }

    private static String dimension(WebElement element) {
        return element.getSize().toString();
    }

    private static String location(WebElement element) {
        return element.getLocation().toString();
    }

    private static String selectedStatus(WebElement element) {
        return Should.isSelectable(element) ? (element.isSelected() ? "selected" : "not selected") : "not selectable";
    }

    private static boolean isSelectable(WebElement element) {
        return element instanceof HtmlInput || element instanceof HtmlOption;
    }
}

