/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.codestory.simplelenium.ActionsOnElement;
import net.codestory.simplelenium.Retry;
import net.codestory.simplelenium.Should;
import net.codestory.simplelenium.driver.CurrentWebDriver;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.filters.ElementFilterBuilder;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public class DomElement {
    private final By selector;
    private final ElementFilter filter;
    private final Retry retry;

    public DomElement(By selector) {
        this(selector, ElementFilter.any(), Retry._30_SECONDS);
    }

    private DomElement(By selector, ElementFilter filter, Retry retry) {
        this.selector = selector;
        this.filter = filter;
        this.retry = retry;
    }

    public DomElement with(ElementFilter filter) {
        return new DomElement(this.selector, this.filter.and(filter), this.retry);
    }

    public ElementFilterBuilder withText() {
        return this.with("text", element -> element.getText());
    }

    public ElementFilterBuilder withId() {
        return this.with("id", element -> element.getAttribute("id"));
    }

    public ElementFilterBuilder withName() {
        return this.with("id", element -> element.getAttribute("name"));
    }

    public ElementFilterBuilder withTagName() {
        return this.with("tag name", element -> element.getTagName());
    }

    public ElementFilterBuilder withClass() {
        return this.with("class", element -> element.getAttribute("class"));
    }

    public ElementFilterBuilder withAttribute(String name) {
        return this.with("attribute[" + name + "]", element -> element.getAttribute(name));
    }

    public ElementFilterBuilder withCssValue(String name) {
        return this.with("cssValue[" + name + "]", element -> element.getCssValue(name));
    }

    private ElementFilterBuilder with(String description, Function<WebElement, String> toValue) {
        return new ElementFilterBuilder(this, description, toValue, ok -> ok);
    }

    public DomElement first() {
        return this.with(new ElementFilter(", first", stream -> stream.limit(1L)));
    }

    public DomElement second() {
        return this.with(new ElementFilter(", second", stream -> stream.skip(1L).limit(1L)));
    }

    public DomElement third() {
        return this.with(new ElementFilter(", third", stream -> stream.skip(2L).limit(1L)));
    }

    public DomElement nth(int index) {
        return this.with(new ElementFilter(", nth[" + index + "]", stream -> stream.skip(index - 1).limit(1L)));
    }

    public DomElement limit(int max) {
        return this.with(new ElementFilter(", limit[" + max + "]", stream -> stream.limit(max)));
    }

    public DomElement skip(int count) {
        return this.with(new ElementFilter(", skip[" + count + "]", stream -> stream.skip(count)));
    }

    public DomElement last() {
        return this.with(new ElementFilter(", last", stream -> DomElement.last(stream)));
    }

    public DomElement withText(String text) {
        return this.withText().contains(text);
    }

    public DomElement withId(String id) {
        return this.withId().equalsTo(id);
    }

    public DomElement withName(String name) {
        return this.withName().equalsTo(name);
    }

    public DomElement withClass(String cssClass) {
        return this.withClass().containsWord(cssClass);
    }

    public DomElement withTagName(String name) {
        return this.withTagName().equalsTo(name);
    }

    public Should should() {
        return new Should(this.selector, this.filter, Retry._5_SECONDS, false);
    }

    public void fill(CharSequence text) {
        this.execute("fill(" + text + ")", element -> element.sendKeys(new CharSequence[]{text}));
    }

    public void pressReturn() {
        this.execute("pressReturn()", element -> element.sendKeys(new CharSequence[]{Keys.RETURN}));
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.execute("sendKeys()", element -> element.sendKeys(keysToSend));
    }

    public void clear() {
        this.execute("clear()", element -> element.clear());
    }

    public void submit() {
        this.execute("submit", element -> element.submit());
    }

    public void click() {
        this.execute("click", element -> element.click());
    }

    public void doubleClick() {
        this.execute("doubleClick", element -> DomElement.actions().doubleClick(element).perform());
    }

    public void clickAndHold() {
        this.execute("clickAndHold", element -> DomElement.actions().clickAndHold(element).perform());
    }

    public void contextClick() {
        this.execute("contextClick", element -> DomElement.actions().contextClick(element).perform());
    }

    public void release() {
        this.execute("release", element -> DomElement.actions().release(element).perform());
    }

    public void select(String text) {
        this.execute("select(" + text + ")", element -> DomElement.selection(element).selectByVisibleText(text));
    }

    public void deselect() {
        this.execute("deselect()", element -> DomElement.selection(element).deselectAll());
    }

    public void deselectByValue(String value) {
        this.execute("deselectByValue(" + value + ")", element -> DomElement.selection(element).deselectByValue(value));
    }

    public void deselectByVisibleText(String text) {
        this.execute("deselectByVisibleText(" + text + ")", element -> DomElement.selection(element).deselectByVisibleText(text));
    }

    public void deselectByIndex(int index) {
        this.execute("deselectByIndex(" + index + ")", element -> DomElement.selection(element).deselectByIndex(index));
    }

    public void selectByIndex(int index) {
        this.execute("selectByIndex(" + index + ")", element -> DomElement.selection(element).selectByIndex(index));
    }

    public void selectByValue(String value) {
        this.execute("selectByValue(" + value + ")", element -> DomElement.selection(element).selectByValue(value));
    }

    public void execute(Consumer<? super WebElement> action) {
        this.execute("execute(" + action + ")", action);
    }

    public void executeActions(ActionsOnElement actionsOnElement) {
        this.execute("execute actions", element -> {
            Actions actions = DomElement.actions();
            actionsOnElement.act(actions, (WebElement)element);
            actions.perform();
        });
    }

    private static <T> Stream<T> last(Stream<T> stream) {
        Iterator iterator = stream.iterator();
        Object last = null;
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last == null ? Stream.empty() : Stream.of(last);
    }

    private static Select selection(WebElement element) {
        return new Select(element);
    }

    private static Actions actions() {
        return new Actions(CurrentWebDriver.get());
    }

    private void execute(String message, Consumer<? super WebElement> action) {
        System.out.println(" - " + Text.toString(this.selector) + this.filter.getDescription() + "." + message);
        this.retry.execute(() -> this.findOne(), action);
    }

    private WebElement findOne() {
        Stream webElements = CurrentWebDriver.get().findElements(this.selector).stream();
        Stream filtered = (Stream)this.filter.getFilter().apply(webElements);
        return filtered.findFirst().orElse(null);
    }
}

