/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.codestory.simplelenium.Retry;
import net.codestory.simplelenium.Should;
import net.codestory.simplelenium.filters.ElementFilter;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class DomElement {
    private final WebDriver driver;
    private final By selector;
    private final ElementFilter narrowSelection;
    private final Retry retry;

    DomElement(WebDriver driver, By selector) {
        this(driver, selector, ElementFilter.any(), Retry._30_SECONDS);
    }

    DomElement(WebDriver driver, By selector, ElementFilter narrowSelection, Retry retry) {
        this.driver = driver;
        this.selector = selector;
        this.narrowSelection = narrowSelection;
        this.retry = retry;
    }

    public DomElement withText(String text) {
        return new DomElement(this.driver, this.selector, ElementFilter.withText(text), this.retry);
    }

    public Should should() {
        return new Should(this.driver, this.selector, this.narrowSelection, Retry._5_SECONDS);
    }

    public Should shouldWithin(long duration, TimeUnit timeUnit) {
        return new Should(this.driver, this.selector, this.narrowSelection, new Retry(duration, timeUnit));
    }

    public void fill(CharSequence text) {
        this.execute("fill(" + text + ")", element -> element.sendKeys(new CharSequence[]{text}));
    }

    public void pressReturn() {
        this.execute("pressReturn()", element -> element.sendKeys(new CharSequence[]{Keys.RETURN}));
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.execute("sendKeys()", element -> element.sendKeys(keysToSend));
    }

    public void clear() {
        this.execute("clear()", element -> element.clear());
    }

    public void submit() {
        this.execute("submit", element -> element.submit());
    }

    public void click() {
        this.execute("click", element -> element.click());
    }

    public void select(String text) {
        this.execute("select(" + text + ")", element -> new Select(element).selectByVisibleText(text));
    }

    public void execute(Consumer<? super WebElement> action) {
        this.execute("execute(" + action + ")", action);
    }

    private void execute(String message, Consumer<? super WebElement> action) {
        System.out.println(" - " + Text.toString(this.selector) + "." + message);
        this.retry.execute(() -> this.find(), action);
    }

    private WebElement find() {
        WebElement element = this.driver.findElement(this.selector);
        if (!this.narrowSelection.test(element)) {
            return null;
        }
        return element;
    }
}

