/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codestory.simplelenium.Retry;
import net.codestory.simplelenium.text.Text;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Should {
    private final WebDriver driver;
    private final By selector;
    private final Retry retry;
    private final boolean not;

    Should(WebDriver driver, By selector, long duration, TimeUnit timeUnit) {
        this(driver, selector, new Retry(duration, timeUnit), false);
    }

    private Should(WebDriver driver, By selector, Retry retry, boolean not) {
        this.driver = driver;
        this.selector = selector;
        this.retry = retry;
        this.not = not;
    }

    public Should not() {
        return new Should(this.driver, this.selector, this.retry, !this.not);
    }

    public Should contain(String ... texts) {
        return this.verify(this.doesOrNot("contain") + " (" + String.join((CharSequence)";", texts) + ")", elements -> Stream.of(texts).allMatch(expected -> elements.stream().anyMatch(element -> element.getText().contains((CharSequence)expected))), elements -> "It contains " + Should.statuses(elements, element -> element.getText()));
    }

    public Should match(Pattern regexp) {
        return this.verify(this.doesOrNot("match") + " (" + regexp.pattern() + ")", elements -> elements.stream().anyMatch(element -> regexp.matcher(element.getText()).matches()), elements -> "It contains " + Should.statuses(elements, element -> element.getText()));
    }

    public Should beEnabled() {
        return this.verify(this.isOrNot("enabled"), elements -> elements.stream().allMatch(element -> element.isEnabled()), elements -> "It is " + Should.statuses(elements, element -> Should.enabledStatus(element)));
    }

    public Should beDisplayed() {
        return this.verify(this.isOrNot("displayed"), elements -> elements.stream().allMatch(element -> element.isDisplayed()), elements -> "It is " + Should.statuses(elements, element -> Should.displayedStatus(element)));
    }

    public Should beSelected() {
        return this.verify(this.isOrNot("selected"), elements -> elements.stream().allMatch(element -> Should.isSelected(element)), elements -> "It is " + Should.statuses(elements, element -> Should.selectedStatus(element)));
    }

    public Should haveLessItemsThan(int maxCount) {
        return this.verify(this.doesOrNot("contain") + " less than " + Text.plural(maxCount, "element"), elements -> elements.size() < maxCount, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should haveSize(int size) {
        return this.verify(this.doesOrNot("contain") + " " + Text.plural(size, "element"), elements -> elements.size() == size, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should haveMoreItemsThan(int minCount) {
        return this.verify(this.doesOrNot("contain") + " more than " + Text.plural(minCount, "element"), elements -> elements.size() > minCount, elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should beEmpty() {
        return this.verify(this.isOrNot("empty"), elements -> elements.isEmpty(), elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    public Should exist() {
        return this.verify(this.doesOrNot("exist"), elements -> !elements.isEmpty(), elements -> "It contains " + Text.plural(elements.size(), "element"));
    }

    private Should verify(String message, Predicate<List<WebElement>> predicate, Function<List<WebElement>, String> toErrorMessage) {
        String verification = "verify that " + Should.toString(this.selector) + " " + message;
        System.out.println("   -> " + verification);
        try {
            if (!this.retry.verify(() -> this.findElements(), this.not ? predicate.negate() : predicate)) {
                throw new AssertionError((Object)("Failed to " + verification + ". " + toErrorMessage.apply(this.findElements())));
            }
        }
        catch (NoSuchElementException e) {
            throw new AssertionError((Object)("Element not found. Failed to " + verification));
        }
        return this.not ? this.not() : this;
    }

    private static String toString(By selector) {
        return selector.toString().replace("By.selector: ", "");
    }

    private List<WebElement> findElements() {
        return this.driver.findElements(this.selector);
    }

    private String doesOrNot(String verb) {
        return Text.doesOrNot(this.not, verb);
    }

    private String isOrNot(String state) {
        return Text.isOrNot(this.not, state);
    }

    private static boolean isSelected(WebElement element) {
        return Should.isSelectable(element) && element.isSelected();
    }

    private static String statuses(List<WebElement> elements, Function<WebElement, String> toStatus) {
        return elements.stream().map(toStatus).collect(Collectors.joining(";", "(", ")"));
    }

    private static String enabledStatus(WebElement element) {
        return element.isEnabled() ? "enabled" : "not enabled";
    }

    private static String displayedStatus(WebElement element) {
        return element.isDisplayed() ? "displayed" : "not displayed";
    }

    private static String selectedStatus(WebElement element) {
        return Should.isSelectable(element) ? (element.isSelected() ? "selected" : "not selected") : "not selectable";
    }

    private static boolean isSelectable(WebElement element) {
        return element instanceof HtmlInput || element instanceof HtmlOption;
    }
}

