/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJsDownloader {
    private final boolean isWindows;
    private final boolean isMac;
    private final ThreadLocal<WebDriver> perThreadDriver = new ThreadLocal<WebDriver>(){

        @Override
        protected WebDriver initialValue() {
            return PhantomJsDownloader.this.createNewDriver();
        }
    };

    public PhantomJsDownloader() {
        this.isWindows = System.getProperty("os.name").startsWith("Windows");
        this.isMac = System.getProperty("os.name").startsWith("Mac OS X");
    }

    public WebDriver getDriverForThread() {
        return this.perThreadDriver.get();
    }

    private WebDriver createNewDriver() {
        System.out.println("Create a new PhantomJSDriver");
        File phantomJsExe = this.downloadAndExtract();
        PhantomJSDriverService service = new PhantomJSDriverService.Builder().usingPhantomJSExecutable(phantomJsExe).withLogFile(new File("target/phantomjs.log")).build();
        PhantomJSDriver driver = new PhantomJSDriver(service, (Capabilities)new DesiredCapabilities());
        return this.disableQuit(driver);
    }

    private WebDriver disableQuit(PhantomJSDriver driver) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((PhantomJSDriver)driver).quit()));
        return (WebDriver)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{WebDriver.class, TakesScreenshot.class, JavascriptExecutor.class}, (proxy, method, args) -> {
            if (method.getName().equals("quit")) {
                return null;
            }
            try {
                return method.invoke((Object)driver, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        });
    }

    private synchronized File downloadAndExtract() {
        File phantomJsExe;
        String url;
        File installDir = new File(new File(System.getProperty("user.home")), ".phantomjstest");
        if (this.isWindows) {
            url = "http://cdn.bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.7-windows.zip";
            phantomJsExe = new File(installDir, "phantomjs-1.9.7-windows/phantomjs.exe");
        } else if (this.isMac) {
            url = "http://cdn.bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.7-macosx.zip";
            phantomJsExe = new File(installDir, "phantomjs-1.9.7-macosx/bin/phantomjs");
        } else {
            url = "http://cdn.bitbucket.org/ariya/phantomjs/downloads/phantomjs-1.9.7-linux-x86_64.tar.bz2";
            phantomJsExe = new File(installDir, "phantomjs-1.9.7-linux-x86_64/bin/phantomjs");
        }
        this.extractExe(url, installDir, phantomJsExe);
        phantomJsExe.setExecutable(true);
        return phantomJsExe;
    }

    private void extractExe(String url, File phantomInstallDir, File phantomJsExe) {
        if (phantomJsExe.exists()) {
            return;
        }
        String zipName = url.substring(url.lastIndexOf(47) + 1);
        File targetZip = new File(phantomInstallDir, zipName);
        this.downloadZip(url, targetZip);
        System.out.println("Extracting phantomjs");
        try {
            if (this.isWindows || this.isMac) {
                PhantomJsDownloader.unzip(targetZip, phantomInstallDir);
            } else {
                PhantomJsDownloader.executeNative(phantomInstallDir, "tar", "xjvf", zipName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to unzip phantomjs from " + targetZip.getAbsolutePath(), e);
        }
    }

    private void downloadZip(String url, File targetZip) {
        if (targetZip.exists()) {
            if (targetZip.length() == 0L) {
                targetZip.delete();
            } else {
                return;
            }
        }
        System.out.printf("Downloading phantomjs from %s...%n", url);
        File zipTemp = new File(targetZip.getAbsolutePath() + ".temp");
        zipTemp.getParentFile().mkdirs();
        try {
            Resources.asByteSource((URL)URI.create(url).toURL()).copyTo(Files.asByteSink((File)zipTemp, (FileWriteMode[])new FileWriteMode[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to download phantomjs from " + url, e);
        }
        if (!zipTemp.renameTo(targetZip)) {
            throw new IllegalStateException(String.format("Unable to rename %s to %s", zipTemp.getAbsolutePath(), targetZip.getAbsolutePath()));
        }
    }

    private static void unzip(File zip, File toDir) throws IOException {
        try (final ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                final ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File to = new File(toDir, entry.getName());
                File parent = to.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Unable to create folder " + parent);
                }
                new ByteSource(){

                    public InputStream openStream() throws IOException {
                        return zipFile.getInputStream(entry);
                    }
                }.copyTo(Files.asByteSink((File)to, (FileWriteMode[])new FileWriteMode[0]));
            }
        }
    }

    private static void executeNative(File workingDir, String ... commands) throws IOException, InterruptedException {
        new ProcessBuilder(new String[0]).command(commands).directory(workingDir).start().waitFor();
    }
}

