/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.osxwatcher;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import net.codestory.http.osxwatcher.CarbonAPI;
import net.codestory.http.osxwatcher.FileChangeListener;

public class Watcher {
    private static final double LATENCY_S = 0.5;
    private static final int FLAGS = 2;
    private final WatcherLoop loop;

    public Watcher(File folder, FileChangeListener listener) {
        this.loop = new WatcherLoop(folder, listener);
    }

    public void start() {
        Thread thread = new Thread(this.loop);
        thread.setDaemon(true);
        thread.start();
        try {
            this.loop.started.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.loop.stop();
    }

    static class WatcherLoop
    implements CarbonAPI.FSEventStreamCallback,
    Runnable {
        private final File folder;
        private final FileChangeListener listener;
        private final CarbonAPI api = CarbonAPI.INSTANCE;
        final CountDownLatch started;
        private PointerByReference stream;
        private PointerByReference runLoop;

        public WatcherLoop(File folder, FileChangeListener listener) {
            this.folder = folder;
            this.listener = listener;
            this.started = new CountDownLatch(1);
        }

        @Override
        public void run() {
            PointerByReference path = this.api.CFArrayCreate(null, new PointerByReference[]{CarbonAPI.toCFString(this.folder.getAbsolutePath())}, 1L, null);
            this.stream = this.api.FSEventStreamCreate(null, this, null, path, -1L, 0.5, 2);
            this.runLoop = this.api.CFRunLoopGetCurrent();
            this.api.FSEventStreamScheduleWithRunLoop(this.stream, this.runLoop, CarbonAPI.toCFString("kCFRunLoopDefaultMode"));
            this.api.FSEventStreamStart(this.stream);
            this.started.countDown();
            this.api.CFRunLoopRun();
        }

        public void stop() {
            this.api.CFRunLoopStop(this.runLoop);
            this.api.FSEventStreamStop(this.stream);
            this.api.FSEventStreamInvalidate(this.stream);
            this.api.FSEventStreamRelease(this.stream);
        }

        @Override
        public void invoke(PointerByReference streamRef, Pointer clientCallBackInfo, long numEvents, Pointer eventPaths, Pointer eventFlags, Pointer eventIds) {
            this.listener.onChange();
        }
    }
}

