/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import net.codestory.http.Context;
import net.codestory.http.annotations.MethodAnnotations;
import net.codestory.http.annotations.Produces;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.AnyRoute;

class ReflectionRoute
implements AnyRoute {
    private final Supplier<Object> resource;
    private final Method method;
    private final MethodAnnotations annotations;

    ReflectionRoute(Supplier<Object> resource, Method method, MethodAnnotations annotations) {
        this.resource = resource;
        this.method = method;
        this.annotations = annotations;
    }

    @Override
    public Object body(Context context, String[] pathParameters) {
        return this.annotations.apply(context, ctx -> {
            try {
                Object target = this.resource.get();
                Object[] arguments = ReflectionRoute.convert(ctx, pathParameters, this.method.getGenericParameterTypes());
                Object response = ReflectionRoute.invoke(target, this.method, arguments);
                Object body = ReflectionRoute.emptyIfNull(response);
                String contentType = ReflectionRoute.findContentType(this.method);
                return new Payload(contentType, body);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalStateException("Unable to apply route", e.getCause());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to apply route", e);
            }
        });
    }

    static Object[] convert(Context context, String[] pathParameters, Type ... types) throws IOException {
        int i;
        Object[] converted = new Object[types.length];
        for (i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.convertValue((Object)pathParameters[i], types[i]);
        }
        for (i = pathParameters.length; i < converted.length; ++i) {
            converted[i] = context.extract(types[i]);
        }
        return converted;
    }

    private static Object invoke(Object target, Method method, Object[] arguments) throws InvocationTargetException, IllegalAccessException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method.invoke(target, arguments);
    }

    private static Object emptyIfNull(Object payload) {
        return payload == null ? "" : payload;
    }

    private static String findContentType(Method method) {
        Produces annotation = method.getAnnotation(Produces.class);
        return annotation == null ? null : annotation.value();
    }
}

